package io.dekorate.servicecatalog.adapter;

import io.dekorate.servicecatalog.annotation.ServiceCatalog;
import java.nio.file.Path;
import java.util.stream.Collectors;
import io.dekorate.servicecatalog.config.ServiceCatalogConfigBuilder;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import java.lang.String;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.servicecatalog.config.Parameter;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.servicecatalog.config.ServiceCatalogConfig;

public class ServiceCatalogConfigAdapter{



    public static ServiceCatalogConfig adapt(ServiceCatalog instance){
            return newBuilder(instance).build();
    }

    public static ServiceCatalogConfigBuilder newBuilder(ServiceCatalog instance){
            return new ServiceCatalogConfigBuilder(new io.dekorate.servicecatalog.config.ServiceCatalogConfig(null,
            null,
            Arrays.asList(instance.instances()).stream().map(i ->new io.dekorate.servicecatalog.config.ServiceCatalogInstance(i.name(),
            i.serviceClass(),
            i.servicePlan(),
            Arrays.asList(i.parameters()).stream().map(j ->new io.dekorate.servicecatalog.config.Parameter(j.key(),
            j.value())).collect(Collectors.toList()).toArray(new io.dekorate.servicecatalog.config.Parameter[0]),
            i.bindingSecret())).collect(Collectors.toList()).toArray(new io.dekorate.servicecatalog.config.ServiceCatalogInstance[0])));
    }

    public static ServiceCatalogConfig adapt(Map map){
            return new io.dekorate.servicecatalog.config.ServiceCatalogConfig(
null,
null,
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("instances" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.servicecatalog.config.ServiceCatalogInstance(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("serviceClass", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("servicePlan", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("parameters" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.servicecatalog.config.Parameter(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.servicecatalog.config.Parameter[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("bindingSecret", "") : ""))).toArray(size-> new io.dekorate.servicecatalog.config.ServiceCatalogInstance[size]));
    }

    public static ServiceCatalogConfigBuilder newBuilder(Map map){
            return new ServiceCatalogConfigBuilder(new io.dekorate.servicecatalog.config.ServiceCatalogConfig(
null,
null,
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("instances" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.servicecatalog.config.ServiceCatalogInstance(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("serviceClass", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("servicePlan", null) : null),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("parameters" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.servicecatalog.config.Parameter(
               (String)(j instanceof Map ? ((Map)j).getOrDefault("key", null) : null),
               (String)(j instanceof Map ? ((Map)j).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.servicecatalog.config.Parameter[size]),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("bindingSecret", "") : ""))).toArray(size-> new io.dekorate.servicecatalog.config.ServiceCatalogInstance[size])));
    }




}
