/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.handler;

import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.servicecatalog.api.model.ServiceBindingBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceBindingFluent;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceBuilder;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.servicecatalog.config.EditableServiceCatalogConfig;
import io.dekorate.servicecatalog.config.Parameter;
import io.dekorate.servicecatalog.config.ServiceCatalogConfig;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.dekorate.utils.Strings;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Description(value="Adds service instance and binding and inject binding info to container environment.")
public class ServiceCatalogHandler
implements Handler<ServiceCatalogConfig> {
    private final Resources resources;

    ServiceCatalogHandler() {
        this(new Resources());
    }

    public ServiceCatalogHandler(Resources resources) {
        this.resources = resources;
    }

    public int order() {
        return 410;
    }

    public void handle(ServiceCatalogConfig config) {
        for (ServiceCatalogInstance instance : config.getInstances()) {
            this.resources.add((HasMetadata)((ServiceInstanceBuilder)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceFluent.SpecNested)((ServiceInstanceBuilder)((ServiceInstanceFluent.MetadataNested)new ServiceInstanceBuilder().withNewMetadata().withName(instance.getName())).endMetadata()).withNewSpec().withClusterServiceClassExternalName(instance.getServiceClass())).withClusterServicePlanExternalName(instance.getServicePlan())).withParameters(ServiceCatalogHandler.toMap(instance.getParameters()))).endSpec()).build());
            if (!Strings.isNotNullOrEmpty((String)instance.getBindingSecret())) continue;
            this.resources.add((HasMetadata)((ServiceBindingBuilder)((ServiceBindingFluent.SpecNested)((ServiceBindingFluent.SpecNested)((ServiceBindingBuilder)((ServiceBindingFluent.MetadataNested)new ServiceBindingBuilder().withNewMetadata().withName(instance.getName())).endMetadata()).withNewSpec().withNewInstanceRef(instance.getName())).withSecretName(instance.getBindingSecret())).endSpec()).build());
            this.resources.decorate((Decorator)new AddEnvVarDecorator(this.resources.getName(), this.resources.getName(), (Env)((EnvBuilder)new EnvBuilder().withSecret(instance.getBindingSecret())).build()));
        }
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(ServiceCatalogConfig.class) || type.equals(EditableServiceCatalogConfig.class);
    }

    protected static Map<String, Object> toMap(Parameter ... parameters) {
        return Arrays.asList(parameters).stream().collect(Collectors.toMap((? super T p) -> p.getKey(), (? super T p) -> p.getValue()));
    }
}

