/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.servicecatalog.config.Parameter;
import io.dekorate.servicecatalog.config.ParameterBuilder;
import io.dekorate.servicecatalog.config.ParameterFluentImpl;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ServiceCatalogInstanceFluentImpl<A extends ServiceCatalogInstanceFluent<A>>
extends BaseFluent<A>
implements ServiceCatalogInstanceFluent<A> {
    private String name;
    private String serviceClass;
    private String servicePlan;
    private List<ParameterBuilder> parameters = new ArrayList<ParameterBuilder>();
    private String bindingSecret = "";

    public ServiceCatalogInstanceFluentImpl() {
    }

    public ServiceCatalogInstanceFluentImpl(ServiceCatalogInstance instance) {
        this.withName(instance.getName());
        this.withServiceClass(instance.getServiceClass());
        this.withServicePlan(instance.getServicePlan());
        this.withParameters(instance.getParameters());
        this.withBindingSecret(instance.getBindingSecret());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public A withServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
        return (A)this;
    }

    @Override
    public Boolean hasServiceClass() {
        return this.serviceClass != null;
    }

    @Override
    public A withNewServiceClass(String arg1) {
        return this.withServiceClass(new String(arg1));
    }

    @Override
    public A withNewServiceClass(StringBuilder arg1) {
        return this.withServiceClass(new String(arg1));
    }

    @Override
    public A withNewServiceClass(StringBuffer arg1) {
        return this.withServiceClass(new String(arg1));
    }

    @Override
    public String getServicePlan() {
        return this.servicePlan;
    }

    @Override
    public A withServicePlan(String servicePlan) {
        this.servicePlan = servicePlan;
        return (A)this;
    }

    @Override
    public Boolean hasServicePlan() {
        return this.servicePlan != null;
    }

    @Override
    public A withNewServicePlan(String arg1) {
        return this.withServicePlan(new String(arg1));
    }

    @Override
    public A withNewServicePlan(StringBuilder arg1) {
        return this.withServicePlan(new String(arg1));
    }

    @Override
    public A withNewServicePlan(StringBuffer arg1) {
        return this.withServicePlan(new String(arg1));
    }

    @Override
    public A withParameters(Parameter ... parameters) {
        if (this.parameters != null) {
            this.parameters.clear();
        }
        if (parameters != null) {
            for (Parameter item : parameters) {
                this.addToParameters(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Parameter[] getParameters() {
        int size = this.parameters != null ? this.parameters.size() : 0;
        Parameter[] result = new Parameter[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.parameters) {
            result[index++] = (Parameter)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Parameter[] buildParameters() {
        int size = this.parameters != null ? this.parameters.size() : 0;
        Parameter[] result = new Parameter[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.parameters) {
            result[index++] = (Parameter)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Parameter buildParameter(int index) {
        return this.parameters.get(index).build();
    }

    @Override
    public Parameter buildFirstParameter() {
        return this.parameters.get(0).build();
    }

    @Override
    public Parameter buildLastParameter() {
        return this.parameters.get(this.parameters.size() - 1).build();
    }

    @Override
    public Parameter buildMatchingParameter(Predicate<ParameterBuilder> predicate) {
        for (ParameterBuilder item : this.parameters) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingParameter(Predicate<ParameterBuilder> predicate) {
        for (ParameterBuilder item : this.parameters) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToParameters(int index, Parameter item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        ParameterBuilder builder = new ParameterBuilder(item);
        this._visitables.get((Object)"parameters").add(index >= 0 ? index : this._visitables.get((Object)"parameters").size(), builder);
        this.parameters.add(index >= 0 ? index : this.parameters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToParameters(int index, Parameter item) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        ParameterBuilder builder = new ParameterBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"parameters").size()) {
            this._visitables.get((Object)"parameters").add(builder);
        } else {
            this._visitables.get((Object)"parameters").set(index, builder);
        }
        if (index < 0 || index >= this.parameters.size()) {
            this.parameters.add(builder);
        } else {
            this.parameters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToParameters(Parameter ... items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToParameters(Collection<Parameter> items) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterBuilder>();
        }
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.get((Object)"parameters").add(builder);
            this.parameters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromParameters(Parameter ... items) {
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.get((Object)"parameters").remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromParameters(Collection<Parameter> items) {
        for (Parameter item : items) {
            ParameterBuilder builder = new ParameterBuilder(item);
            this._visitables.get((Object)"parameters").remove(builder);
            if (this.parameters == null) continue;
            this.parameters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromParameters(Predicate<ParameterBuilder> predicate) {
        if (this.parameters == null) {
            return (A)this;
        }
        Iterator<ParameterBuilder> each = this.parameters.iterator();
        List visitables = this._visitables.get((Object)"parameters");
        while (each.hasNext()) {
            ParameterBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    @Override
    public A addNewParameter(String key, String value) {
        return this.addToParameters(new Parameter(key, value));
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameter() {
        return new ParametersNestedImpl();
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> addNewParameterLike(Parameter item) {
        return new ParametersNestedImpl(-1, item);
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> setNewParameterLike(int index, Parameter item) {
        return new ParametersNestedImpl(index, item);
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> editParameter(int index) {
        if (this.parameters.size() <= index) {
            throw new RuntimeException("Can't edit parameters. Index exceeds size.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> editFirstParameter() {
        if (this.parameters.size() == 0) {
            throw new RuntimeException("Can't edit first parameters. The list is empty.");
        }
        return this.setNewParameterLike(0, this.buildParameter(0));
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> editLastParameter() {
        int index = this.parameters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parameters. The list is empty.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public ServiceCatalogInstanceFluent.ParametersNested<A> editMatchingParameter(Predicate<ParameterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!predicate.apply((Object)this.parameters.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parameters. No match found.");
        }
        return this.setNewParameterLike(index, this.buildParameter(index));
    }

    @Override
    public String getBindingSecret() {
        return this.bindingSecret;
    }

    @Override
    public A withBindingSecret(String bindingSecret) {
        this.bindingSecret = bindingSecret;
        return (A)this;
    }

    @Override
    public Boolean hasBindingSecret() {
        return this.bindingSecret != null;
    }

    @Override
    public A withNewBindingSecret(String arg1) {
        return this.withBindingSecret(new String(arg1));
    }

    @Override
    public A withNewBindingSecret(StringBuilder arg1) {
        return this.withBindingSecret(new String(arg1));
    }

    @Override
    public A withNewBindingSecret(StringBuffer arg1) {
        return this.withBindingSecret(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCatalogInstanceFluentImpl that = (ServiceCatalogInstanceFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.serviceClass != null ? !this.serviceClass.equals(that.serviceClass) : that.serviceClass != null) {
            return false;
        }
        if (this.servicePlan != null ? !this.servicePlan.equals(that.servicePlan) : that.servicePlan != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        return !(this.bindingSecret != null ? !this.bindingSecret.equals(that.bindingSecret) : that.bindingSecret != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.serviceClass, this.servicePlan, this.parameters, this.bindingSecret, super.hashCode());
    }

    public class ParametersNestedImpl<N>
    extends ParameterFluentImpl<ServiceCatalogInstanceFluent.ParametersNested<N>>
    implements ServiceCatalogInstanceFluent.ParametersNested<N>,
    Nested<N> {
        private final ParameterBuilder builder;
        private final int index;

        ParametersNestedImpl(int index, Parameter item) {
            this.index = index;
            this.builder = new ParameterBuilder(this, item);
        }

        ParametersNestedImpl() {
            this.index = -1;
            this.builder = new ParameterBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceCatalogInstanceFluentImpl.this.setToParameters(this.index, this.builder.build());
        }

        @Override
        public N endParameter() {
            return this.and();
        }
    }
}

