/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.dekorate.servicecatalog.config.ServiceCatalogConfig;
import io.dekorate.servicecatalog.config.ServiceCatalogConfigFluent;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ServiceCatalogConfigFluentImpl<A extends ServiceCatalogConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements ServiceCatalogConfigFluent<A> {
    private List<ServiceCatalogInstanceBuilder> instances = new ArrayList<ServiceCatalogInstanceBuilder>();

    public ServiceCatalogConfigFluentImpl() {
    }

    public ServiceCatalogConfigFluentImpl(ServiceCatalogConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withInstances(instance.getInstances());
    }

    @Override
    public A withInstances(ServiceCatalogInstance ... instances) {
        if (this.instances != null) {
            this.instances.clear();
        }
        if (instances != null) {
            for (ServiceCatalogInstance item : instances) {
                this.addToInstances(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public ServiceCatalogInstance[] getInstances() {
        int size = this.instances != null ? this.instances.size() : 0;
        ServiceCatalogInstance[] result = new ServiceCatalogInstance[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.instances) {
            result[index++] = (ServiceCatalogInstance)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ServiceCatalogInstance[] buildInstances() {
        int size = this.instances != null ? this.instances.size() : 0;
        ServiceCatalogInstance[] result = new ServiceCatalogInstance[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.instances) {
            result[index++] = (ServiceCatalogInstance)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ServiceCatalogInstance buildInstance(int index) {
        return this.instances.get(index).build();
    }

    @Override
    public ServiceCatalogInstance buildFirstInstance() {
        return this.instances.get(0).build();
    }

    @Override
    public ServiceCatalogInstance buildLastInstance() {
        return this.instances.get(this.instances.size() - 1).build();
    }

    @Override
    public ServiceCatalogInstance buildMatchingInstance(Predicate<ServiceCatalogInstanceBuilder> predicate) {
        for (ServiceCatalogInstanceBuilder item : this.instances) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInstance(Predicate<ServiceCatalogInstanceBuilder> predicate) {
        for (ServiceCatalogInstanceBuilder item : this.instances) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToInstances(int index, ServiceCatalogInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList<ServiceCatalogInstanceBuilder>();
        }
        ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
        this._visitables.get((Object)"instances").add(index >= 0 ? index : this._visitables.get((Object)"instances").size(), builder);
        this.instances.add(index >= 0 ? index : this.instances.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInstances(int index, ServiceCatalogInstance item) {
        if (this.instances == null) {
            this.instances = new ArrayList<ServiceCatalogInstanceBuilder>();
        }
        ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"instances").size()) {
            this._visitables.get((Object)"instances").add(builder);
        } else {
            this._visitables.get((Object)"instances").set(index, builder);
        }
        if (index < 0 || index >= this.instances.size()) {
            this.instances.add(builder);
        } else {
            this.instances.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInstances(ServiceCatalogInstance ... items) {
        if (this.instances == null) {
            this.instances = new ArrayList<ServiceCatalogInstanceBuilder>();
        }
        for (ServiceCatalogInstance item : items) {
            ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
            this._visitables.get((Object)"instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInstances(Collection<ServiceCatalogInstance> items) {
        if (this.instances == null) {
            this.instances = new ArrayList<ServiceCatalogInstanceBuilder>();
        }
        for (ServiceCatalogInstance item : items) {
            ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
            this._visitables.get((Object)"instances").add(builder);
            this.instances.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInstances(ServiceCatalogInstance ... items) {
        for (ServiceCatalogInstance item : items) {
            ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
            this._visitables.get((Object)"instances").remove(builder);
            if (this.instances == null) continue;
            this.instances.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInstances(Collection<ServiceCatalogInstance> items) {
        for (ServiceCatalogInstance item : items) {
            ServiceCatalogInstanceBuilder builder = new ServiceCatalogInstanceBuilder(item);
            this._visitables.get((Object)"instances").remove(builder);
            if (this.instances == null) continue;
            this.instances.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInstances(Predicate<ServiceCatalogInstanceBuilder> predicate) {
        if (this.instances == null) {
            return (A)this;
        }
        Iterator<ServiceCatalogInstanceBuilder> each = this.instances.iterator();
        List visitables = this._visitables.get((Object)"instances");
        while (each.hasNext()) {
            ServiceCatalogInstanceBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstances() {
        return this.instances != null && !this.instances.isEmpty();
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> addNewInstance() {
        return new InstancesNestedImpl();
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> addNewInstanceLike(ServiceCatalogInstance item) {
        return new InstancesNestedImpl(-1, item);
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> setNewInstanceLike(int index, ServiceCatalogInstance item) {
        return new InstancesNestedImpl(index, item);
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> editInstance(int index) {
        if (this.instances.size() <= index) {
            throw new RuntimeException("Can't edit instances. Index exceeds size.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> editFirstInstance() {
        if (this.instances.size() == 0) {
            throw new RuntimeException("Can't edit first instances. The list is empty.");
        }
        return this.setNewInstanceLike(0, this.buildInstance(0));
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> editLastInstance() {
        int index = this.instances.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last instances. The list is empty.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    @Override
    public ServiceCatalogConfigFluent.InstancesNested<A> editMatchingInstance(Predicate<ServiceCatalogInstanceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.instances.size(); ++i) {
            if (!predicate.apply((Object)this.instances.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching instances. No match found.");
        }
        return this.setNewInstanceLike(index, this.buildInstance(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceCatalogConfigFluentImpl that = (ServiceCatalogConfigFluentImpl)o;
        return !(this.instances != null ? !this.instances.equals(that.instances) : that.instances != null);
    }

    public int hashCode() {
        return Objects.hash(this.instances, super.hashCode());
    }

    public class InstancesNestedImpl<N>
    extends ServiceCatalogInstanceFluentImpl<ServiceCatalogConfigFluent.InstancesNested<N>>
    implements ServiceCatalogConfigFluent.InstancesNested<N>,
    Nested<N> {
        private final ServiceCatalogInstanceBuilder builder;
        private final int index;

        InstancesNestedImpl(int index, ServiceCatalogInstance item) {
            this.index = index;
            this.builder = new ServiceCatalogInstanceBuilder(this, item);
        }

        InstancesNestedImpl() {
            this.index = -1;
            this.builder = new ServiceCatalogInstanceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceCatalogConfigFluentImpl.this.setToInstances(this.index, this.builder.build());
        }

        @Override
        public N endInstance() {
            return this.and();
        }
    }
}

