package io.dekorate.servicecatalog.adapter;

import java.util.stream.Collectors;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder;
import io.dekorate.servicecatalog.config.Parameter;
import io.dekorate.servicecatalog.annotation.ServiceCatalogInstance;
import java.lang.String;
import java.util.Arrays;
import java.util.Map;
import java.util.Comparator;

public class ServiceCatalogInstanceAdapter{



    public static io.dekorate.servicecatalog.config.ServiceCatalogInstance adapt(ServiceCatalogInstance instance){
            return newBuilder(instance).build();
    }

    public static io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder newBuilder(ServiceCatalogInstance instance){
            return new ServiceCatalogInstanceBuilder(new io.dekorate.servicecatalog.config.ServiceCatalogInstance(instance.name(),
            instance.serviceClass(),
            instance.servicePlan(),
            Arrays.asList(instance.parameters()).stream().map(i ->new io.dekorate.servicecatalog.config.Parameter(i.key(),
            i.value())).collect(Collectors.toList()).toArray(new io.dekorate.servicecatalog.config.Parameter[0]),
            instance.bindingSecret()));
    }

    public static io.dekorate.servicecatalog.config.ServiceCatalogInstance adapt(Map map){
            return new io.dekorate.servicecatalog.config.ServiceCatalogInstance(
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceClass", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("servicePlan", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("parameters" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.servicecatalog.config.Parameter(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.servicecatalog.config.Parameter[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("bindingSecret", "") : ""));
    }

    public static io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder newBuilder(Map map){
            return new ServiceCatalogInstanceBuilder(new io.dekorate.servicecatalog.config.ServiceCatalogInstance(
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("serviceClass", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("servicePlan", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("parameters" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.servicecatalog.config.Parameter(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new io.dekorate.servicecatalog.config.Parameter[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("bindingSecret", "") : "")));
    }




}
