/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.servicecatalog.config.EditableServiceCatalogInstance;
import io.dekorate.servicecatalog.config.ServiceCatalogInstance;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent;
import io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluentImpl;

public class ServiceCatalogInstanceBuilder
extends ServiceCatalogInstanceFluentImpl<ServiceCatalogInstanceBuilder>
implements VisitableBuilder<ServiceCatalogInstance, ServiceCatalogInstanceBuilder> {
    ServiceCatalogInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogInstanceBuilder() {
        this(true);
    }

    public ServiceCatalogInstanceBuilder(Boolean validationEnabled) {
        this(new ServiceCatalogInstance(), validationEnabled);
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstanceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstanceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceCatalogInstance(), validationEnabled);
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstanceFluent<?> fluent, ServiceCatalogInstance instance) {
        this(fluent, instance, true);
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstanceFluent<?> fluent, ServiceCatalogInstance instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withServiceClass(instance.getServiceClass());
        fluent.withServicePlan(instance.getServicePlan());
        fluent.withParameters(instance.getParameters());
        fluent.withBindingSecret(instance.getBindingSecret());
        this.validationEnabled = validationEnabled;
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstance instance) {
        this(instance, (Boolean)true);
    }

    public ServiceCatalogInstanceBuilder(ServiceCatalogInstance instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withServiceClass(instance.getServiceClass());
        this.withServicePlan(instance.getServicePlan());
        this.withParameters(instance.getParameters());
        this.withBindingSecret(instance.getBindingSecret());
        this.validationEnabled = validationEnabled;
    }

    public EditableServiceCatalogInstance build() {
        EditableServiceCatalogInstance buildable = new EditableServiceCatalogInstance(this.fluent.getName(), this.fluent.getServiceClass(), this.fluent.getServicePlan(), this.fluent.getParameters(), this.fluent.getBindingSecret());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceCatalogInstanceBuilder that = (ServiceCatalogInstanceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

