package io.dekorate.servicecatalog.config;

import java.lang.String;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class ServiceCatalogInstance{

    private String name;
    private String serviceClass;
    private String servicePlan;
    private io.dekorate.servicecatalog.config.Parameter[] parameters = new io.dekorate.servicecatalog.config.Parameter[0];
    private String bindingSecret = "";

    public ServiceCatalogInstance(){
    }
    public ServiceCatalogInstance(String name,String serviceClass,String servicePlan,io.dekorate.servicecatalog.config.Parameter[] parameters,String bindingSecret){
            this.name = name;
            this.serviceClass = serviceClass;
            this.servicePlan = servicePlan;
            this.parameters = parameters != null ? parameters : new io.dekorate.servicecatalog.config.Parameter[0];
            this.bindingSecret = bindingSecret != null ? bindingSecret : "";
    }

    public String getName(){
            return this.name;
    }

    public String getServiceClass(){
            return this.serviceClass;
    }

    public String getServicePlan(){
            return this.servicePlan;
    }

    public io.dekorate.servicecatalog.config.Parameter[] getParameters(){
            return this.parameters;
    }

    public String getBindingSecret(){
            return this.bindingSecret;
    }




}
