package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServiceCatalogConfigFluentImpl<A extends ServiceCatalogConfigFluent<A>> extends ConfigurationFluentImpl<A> implements ServiceCatalogConfigFluent<A>{

    private List<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> instances =  new ArrayList<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>();

    public ServiceCatalogConfigFluentImpl(){
    }
    public ServiceCatalogConfigFluentImpl(ServiceCatalogConfig instance){
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withInstances(instance.getInstances()); 
    }

    public A withInstances(io.dekorate.servicecatalog.config.ServiceCatalogInstance... instances){
            if (this.instances != null) {this.instances.clear();}
            if (instances != null) {for (io.dekorate.servicecatalog.config.ServiceCatalogInstance item :instances){ this.addToInstances(item);}} return (A) this;
    }

    
/**
 * This method has been deprecated, please use method buildInstances instead.
 */
@Deprecated public io.dekorate.servicecatalog.config.ServiceCatalogInstance[] getInstances(){
            int size = instances != null ? instances.size() : 0;
io.dekorate.servicecatalog.config.ServiceCatalogInstance[] result = new io.dekorate.servicecatalog.config.ServiceCatalogInstance[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.servicecatalog.config.ServiceCatalogInstance,?> builder : instances) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance[] buildInstances(){
            int size = instances != null ? instances.size() : 0;
io.dekorate.servicecatalog.config.ServiceCatalogInstance[] result = new io.dekorate.servicecatalog.config.ServiceCatalogInstance[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.servicecatalog.config.ServiceCatalogInstance,?> builder : instances) {
    result[index++]=builder.build();
}
return result;

    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance buildInstance(int index){
            return this.instances.get(index).build();
    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance buildFirstInstance(){
            return this.instances.get(0).build();
    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance buildLastInstance(){
            return this.instances.get(instances.size() - 1).build();
    }

    public io.dekorate.servicecatalog.config.ServiceCatalogInstance buildMatchingInstance(io.dekorate.deps.kubernetes.api.builder.Predicate<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> predicate){
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder item: instances) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingInstance(io.dekorate.deps.kubernetes.api.builder.Predicate<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> predicate){
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder item: instances) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A addToInstances(int index,io.dekorate.servicecatalog.config.ServiceCatalogInstance item){
            if (this.instances == null) {this.instances = new ArrayList<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>();}
            io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);_visitables.get("instances").add(index >= 0 ? index : _visitables.get("instances").size(), builder);this.instances.add(index >= 0 ? index : instances.size(), builder); return (A)this;
    }

    public A setToInstances(int index,io.dekorate.servicecatalog.config.ServiceCatalogInstance item){
            if (this.instances == null) {this.instances = new ArrayList<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>();}
            io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);
            if (index < 0 || index >= _visitables.get("instances").size()) { _visitables.get("instances").add(builder); } else { _visitables.get("instances").set(index, builder);}
            if (index < 0 || index >= instances.size()) { instances.add(builder); } else { instances.set(index, builder);}
             return (A)this;
    }

    public A addToInstances(io.dekorate.servicecatalog.config.ServiceCatalogInstance... items){
            if (this.instances == null) {this.instances = new ArrayList<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>();}
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstance item : items) {io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
    }

    public A addAllToInstances(Collection<io.dekorate.servicecatalog.config.ServiceCatalogInstance> items){
            if (this.instances == null) {this.instances = new ArrayList<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>();}
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstance item : items) {io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
    }

    public A removeFromInstances(io.dekorate.servicecatalog.config.ServiceCatalogInstance... items){
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstance item : items) {io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);_visitables.get("instances").remove(builder);if (this.instances != null) {this.instances.remove(builder);}} return (A)this;
    }

    public A removeAllFromInstances(Collection<io.dekorate.servicecatalog.config.ServiceCatalogInstance> items){
            for (io.dekorate.servicecatalog.config.ServiceCatalogInstance item : items) {io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(item);_visitables.get("instances").remove(builder);if (this.instances != null) {this.instances.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromInstances(io.dekorate.deps.kubernetes.api.builder.Predicate<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> predicate){
            if (instances == null) return (A) this;
            final Iterator<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> each = instances.iterator();
            final List visitables = _visitables.get("instances");
            while (each.hasNext()) {
              io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public Boolean hasInstances(){
            return instances != null && !instances.isEmpty();
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> addNewInstance(){
            return new InstancesNestedImpl();
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> addNewInstanceLike(io.dekorate.servicecatalog.config.ServiceCatalogInstance item){
            return new InstancesNestedImpl(-1, item);
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> setNewInstanceLike(int index,io.dekorate.servicecatalog.config.ServiceCatalogInstance item){
            return new InstancesNestedImpl(index, item);
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> editInstance(int index){
            if (instances.size() <= index) throw new RuntimeException("Can't edit instances. Index exceeds size.");
            return setNewInstanceLike(index, buildInstance(index));
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> editFirstInstance(){
            if (instances.size() == 0) throw new RuntimeException("Can't edit first instances. The list is empty.");
            return setNewInstanceLike(0, buildInstance(0));
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> editLastInstance(){
            int index = instances.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last instances. The list is empty.");
            return setNewInstanceLike(index, buildInstance(index));
    }

    public ServiceCatalogConfigFluent.InstancesNested<A> editMatchingInstance(io.dekorate.deps.kubernetes.api.builder.Predicate<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> predicate){
            int index = -1;
            for (int i=0;i<instances.size();i++) { 
            if (predicate.apply(instances.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching instances. No match found.");
            return setNewInstanceLike(index, buildInstance(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCatalogConfigFluentImpl that = (ServiceCatalogConfigFluentImpl) o;
            if (instances != null ? !instances.equals(that.instances) :that.instances != null) return false;
            return true;
    }


    public class InstancesNestedImpl<N> extends io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluentImpl<ServiceCatalogConfigFluent.InstancesNested<N>> implements ServiceCatalogConfigFluent.InstancesNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N>{

            private final io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder builder;
        private final int index;
    
            InstancesNestedImpl(int index,io.dekorate.servicecatalog.config.ServiceCatalogInstance item){
                    this.index = index;
                    this.builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(this, item);
            }
            InstancesNestedImpl(){
                    this.index = -1;
                    this.builder = new io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder(this);
            }
    
    public N and(){
            return (N) ServiceCatalogConfigFluentImpl.this.setToInstances(index, builder.build());
    }
    public N endInstance(){
            return and();
    }

}


}
