package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogConfigBuilder extends ServiceCatalogConfigFluentImpl<ServiceCatalogConfigBuilder> implements VisitableBuilder<ServiceCatalogConfig,ServiceCatalogConfigBuilder>{

    ServiceCatalogConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogConfigBuilder(){
            this(true);
    }
    public ServiceCatalogConfigBuilder(Boolean validationEnabled){
            this(new ServiceCatalogConfig(), validationEnabled);
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceCatalogConfig(), validationEnabled);
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfigFluent<?> fluent,ServiceCatalogConfig instance){
            this(fluent, instance, true);
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfigFluent<?> fluent,ServiceCatalogConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject()); 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withInstances(instance.getInstances()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfig instance){
            this(instance,true);
    }
    public ServiceCatalogConfigBuilder(ServiceCatalogConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withInstances(instance.getInstances()); 
            this.validationEnabled = validationEnabled; 
    }

    public EditableServiceCatalogConfig build(){
            EditableServiceCatalogConfig buildable = new EditableServiceCatalogConfig(fluent.getProject(),fluent.getAttributes(),fluent.getInstances());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCatalogConfigBuilder that = (ServiceCatalogConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
