package io.dekorate.servicecatalog.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogInstanceBuilder extends io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluentImpl<io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder> implements VisitableBuilder<io.dekorate.servicecatalog.config.ServiceCatalogInstance,io.dekorate.servicecatalog.config.ServiceCatalogInstanceBuilder>{

    io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogInstanceBuilder(){
            this(true);
    }
    public ServiceCatalogInstanceBuilder(Boolean validationEnabled){
            this(new ServiceCatalogInstance(), validationEnabled);
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceCatalogInstance(), validationEnabled);
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<?> fluent,io.dekorate.servicecatalog.config.ServiceCatalogInstance instance){
            this(fluent, instance, true);
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstanceFluent<?> fluent,io.dekorate.servicecatalog.config.ServiceCatalogInstance instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withServiceClass(instance.getServiceClass()); 
            fluent.withServicePlan(instance.getServicePlan()); 
            fluent.withParameters(instance.getParameters()); 
            fluent.withBindingSecret(instance.getBindingSecret()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstance instance){
            this(instance,true);
    }
    public ServiceCatalogInstanceBuilder(io.dekorate.servicecatalog.config.ServiceCatalogInstance instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withServiceClass(instance.getServiceClass()); 
            this.withServicePlan(instance.getServicePlan()); 
            this.withParameters(instance.getParameters()); 
            this.withBindingSecret(instance.getBindingSecret()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.dekorate.servicecatalog.config.EditableServiceCatalogInstance build(){
            EditableServiceCatalogInstance buildable = new EditableServiceCatalogInstance(fluent.getName(),fluent.getServiceClass(),fluent.getServicePlan(),fluent.getParameters(),fluent.getBindingSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceCatalogInstanceBuilder that = (ServiceCatalogInstanceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
