package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluent<ServiceMonitorSpecBuilder> implements VisitableBuilder<ServiceMonitorSpec,ServiceMonitorSpecBuilder>{
  public ServiceMonitorSpecBuilder() {
    this(new ServiceMonitorSpec());
  }
  
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent) {
    this(fluent, new ServiceMonitorSpec());
  }
  
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceMonitorSpecFluent<?> fluent;
  
  public ServiceMonitorSpec build() {
    ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.buildSelector(),fluent.buildEndpoints());
    return buildable;
  }
  

}