/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.model;

import io.dekorate.prometheus.model.Endpoint;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;

public class EndpointFluent<A extends EndpointFluent<A>>
extends BaseFluent<A> {
    private String port;
    private String path;
    private String interval;
    private boolean honorLabels;

    public EndpointFluent() {
    }

    public EndpointFluent(Endpoint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Endpoint instance) {
        Endpoint endpoint = instance = instance != null ? instance : new Endpoint();
        if (instance != null) {
            this.withPort(instance.getPort());
            this.withPath(instance.getPath());
            this.withInterval(instance.getInterval());
            this.withHonorLabels(instance.isHonorLabels());
        }
    }

    public String getPort() {
        return this.port;
    }

    public A withPort(String port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval = interval;
        return (A)((Object)this);
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public boolean isHonorLabels() {
        return this.honorLabels;
    }

    public A withHonorLabels(boolean honorLabels) {
        this.honorLabels = honorLabels;
        return (A)((Object)this);
    }

    public boolean hasHonorLabels() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointFluent that = (EndpointFluent)((Object)o);
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        return this.honorLabels == that.honorLabels;
    }

    public int hashCode() {
        return Objects.hash(this.port, this.path, this.interval, this.honorLabels, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.interval != null) {
            sb.append("interval:");
            sb.append(this.interval + ",");
        }
        sb.append("honorLabels:");
        sb.append(this.honorLabels);
        sb.append("}");
        return sb.toString();
    }

    public A withHonorLabels() {
        return this.withHonorLabels(true);
    }
}

