package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPort(instance.getPort()); 
    fluent.withPath(instance.getPath()); 
    fluent.withInterval(instance.getInterval()); 
    fluent.withHonorLabels(instance.isHonorLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(Endpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPort(instance.getPort()); 
    this.withPath(instance.getPath()); 
    this.withInterval(instance.getInterval()); 
    this.withHonorLabels(instance.isHonorLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  EndpointFluent<?> fluent;
  Boolean validationEnabled;
  public Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getPort(),fluent.getPath(),fluent.getInterval(),fluent.isHonorLabels());
    return buildable;
  }
  
}