package io.dekorate.prometheus.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointFluentImpl<A extends EndpointFluent<A>> extends BaseFluent<A> implements EndpointFluent<A>{
  public EndpointFluentImpl() {
  }
  public EndpointFluentImpl(Endpoint instance) {
    this.withPort(instance.getPort()); 
    this.withPath(instance.getPath()); 
    this.withInterval(instance.getInterval()); 
    this.withHonorLabels(instance.isHonorLabels()); 
  }
  private String port;
  private String path;
  private String interval;
  private boolean honorLabels;
  public String getPort() {
    return this.port;
  }
  public A withPort(String port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public String getInterval() {
    return this.interval;
  }
  public A withInterval(String interval) {
    this.interval=interval; return (A) this;
  }
  public Boolean hasInterval() {
    return this.interval != null;
  }
  public boolean isHonorLabels() {
    return this.honorLabels;
  }
  public A withHonorLabels(boolean honorLabels) {
    this.honorLabels=honorLabels; return (A) this;
  }
  public Boolean hasHonorLabels() {
    return true;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    EndpointFluentImpl that = (EndpointFluentImpl) o;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (honorLabels != that.honorLabels) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (interval != null) { sb.append("interval:"); sb.append(interval + ","); }
    sb.append("honorLabels:"); sb.append(honorLabels);
    sb.append("}");
    return sb.toString();
  }
  public A withHonorLabels() {
    return withHonorLabels(true);
  }
  
}