package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceMonitorSpecFluentImpl<A extends ServiceMonitorSpecFluent<A>> extends BaseFluent<A> implements ServiceMonitorSpecFluent<A>{
  public ServiceMonitorSpecFluentImpl() {
  }
  public ServiceMonitorSpecFluentImpl(ServiceMonitorSpec instance) {
    this.withSelector(instance.getSelector()); 
    this.withEndpoints(instance.getEndpoints()); 
  }
  private LabelSelectorBuilder selector;
  private ArrayList<EndpointBuilder> endpoints;
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
    return new ServiceMonitorSpecFluentImpl.SelectorNestedImpl();
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ServiceMonitorSpecFluentImpl.SelectorNestedImpl(item);
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public A addToEndpoints(Integer index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(Integer index,Endpoint item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    EndpointBuilder builder = new EndpointBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.dekorate.prometheus.model.Endpoint... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(Collection<Endpoint> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<EndpointBuilder>();}
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.dekorate.prometheus.model.Endpoint... items) {
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(Collection<Endpoint> items) {
    for (Endpoint item : items) {EndpointBuilder builder = new EndpointBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<EndpointBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      EndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Endpoint> getEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public List<Endpoint> buildEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public Endpoint buildEndpoint(Integer index) {
    return this.endpoints.get(index).build();
  }
  public Endpoint buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public Endpoint buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    for (EndpointBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(List<Endpoint> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new ArrayList(); for (Endpoint item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.dekorate.prometheus.model.Endpoint... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (Endpoint item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public A addNewEndpoint(String port,String path,String interval,boolean honorLabels) {
    return (A)addToEndpoints(new Endpoint(port, path, interval, honorLabels));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl();
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(Integer index,Endpoint item) {
    return new ServiceMonitorSpecFluentImpl.EndpointsNestedImpl(index, item);
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl) o;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(selector,  endpoints,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ServiceMonitorSpecFluent.SelectorNested<N>> implements ServiceMonitorSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class EndpointsNestedImpl<N> extends EndpointFluentImpl<ServiceMonitorSpecFluent.EndpointsNested<N>> implements ServiceMonitorSpecFluent.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(Integer index,Endpoint item) {
      this.index = index;
      this.builder = new EndpointBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointBuilder(this);
    }
    EndpointBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceMonitorSpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  
}