/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.prometheus.config.ServiceMonitorConfig;
import io.dekorate.prometheus.model.ServiceMonitorBuilder;
import io.dekorate.prometheus.model.ServiceMonitorFluent;
import io.dekorate.prometheus.model.ServiceMonitorSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;

@Description(value="Add a ServiceMonitor resource to the list of generated resources.")
public class AddServiceMonitorResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final ServiceMonitorConfig config;

    public AddServiceMonitorResourceDecorator(ServiceMonitorConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list, ANY);
        list.addToItems((VisitableBuilder)((ServiceMonitorFluent.SpecNested)((ServiceMonitorSpecFluent.EndpointsNested)((ServiceMonitorSpecFluent.EndpointsNested)((ServiceMonitorSpecFluent.EndpointsNested)((ServiceMonitorSpecFluent.EndpointsNested)((ServiceMonitorFluent.SpecNested)((ServiceMonitorSpecFluent.SelectorNested)((ServiceMonitorBuilder)((ServiceMonitorFluent.MetadataNested)((ServiceMonitorFluent.MetadataNested)new ServiceMonitorBuilder().withNewMetadata().withName(meta.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withNewSelector().addToMatchLabels(meta.getLabels())).endSelector()).addNewEndpoint().withPort(this.config.getPort())).withPath(this.config.getPath())).withInterval(this.config.getInterval() + "s")).withHonorLabels(this.config.isHonorLabels())).endEndpoint()).endSpec());
    }
}

