package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder> implements VisitableBuilder<ServiceMonitorSpec,ServiceMonitorSpecBuilder>{
  public ServiceMonitorSpecBuilder() {
    this(false);
  }
  public ServiceMonitorSpecBuilder(Boolean validationEnabled) {
    this(new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSelector(instance.getSelector()); 
    fluent.withEndpoints(instance.getEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance) {
    this(instance,false);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSelector(instance.getSelector()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceMonitorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceMonitorSpec build() {
    ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getSelector(),fluent.getEndpoints());
    return buildable;
  }
  
}