package io.dekorate.prometheus.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class ServiceMonitorConfig extends Configuration{
  public ServiceMonitorConfig() {
  }
  public ServiceMonitorConfig(Project project,Map<ConfigKey,Object> attributes,String port,java.lang.String path,Integer interval,Boolean honorLabels) {
    super(project, attributes);
    this.port = port;
    this.path = path;
    this.interval = interval;
    this.honorLabels = honorLabels;
  }
  private java.lang.String port;
  private java.lang.String path;
  private java.lang.Integer interval;
  private java.lang.Boolean honorLabels;
  public java.lang.String getPort() {
    return this.port;
  }
  public java.lang.String getPath() {
    return this.path;
  }
  public java.lang.Integer getInterval() {
    return this.interval;
  }
  public java.lang.Boolean getHonorLabels() {
    return this.honorLabels;
  }
  public boolean isHonorLabels() {
    return this.honorLabels != null &&  this.honorLabels;
  }
  public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
    return new ServiceMonitorConfigBuilder();
  }
  public static io.dekorate.prometheus.config.ServiceMonitorConfigBuilder newServiceMonitorConfigBuilderFromDefaults() {
    return new io.dekorate.prometheus.config.ServiceMonitorConfigBuilder().withPort("http").withPath("/metrics").withInterval(10).withHonorLabels(false);
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServiceMonitorConfig that = (ServiceMonitorConfig) o;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
    if (honorLabels != null ? !honorLabels.equals(that.honorLabels) :that.honorLabels != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
  }
  
}