/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.model;

import io.dekorate.prometheus.model.Endpoint;
import io.dekorate.prometheus.model.EndpointFluent;
import io.dekorate.prometheus.model.EndpointFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class EndpointBuilder
extends EndpointFluentImpl<EndpointBuilder>
implements VisitableBuilder<Endpoint, EndpointBuilder> {
    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() {
        this(false);
    }

    public EndpointBuilder(Boolean validationEnabled) {
        this(new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance) {
        this(fluent, instance, false);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPort(instance.getPort());
        fluent.withPath(instance.getPath());
        fluent.withInterval(instance.getInterval());
        fluent.withHonorLabels(instance.isHonorLabels());
        this.validationEnabled = validationEnabled;
    }

    public EndpointBuilder(Endpoint instance) {
        this(instance, (Boolean)false);
    }

    public EndpointBuilder(Endpoint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPort(instance.getPort());
        this.withPath(instance.getPath());
        this.withInterval(instance.getInterval());
        this.withHonorLabels(instance.isHonorLabels());
        this.validationEnabled = validationEnabled;
    }

    public Endpoint build() {
        Endpoint buildable = new Endpoint(this.fluent.getPort(), this.fluent.getPath(), this.fluent.getInterval(), this.fluent.isHonorLabels());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointBuilder that = (EndpointBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

