package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<io.dekorate.prometheus.model.Endpoint,EndpointBuilder>{
  public EndpointBuilder() {
    this(false);
  }
  public EndpointBuilder(Boolean validationEnabled) {
    this(new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.dekorate.prometheus.model.EndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointBuilder(io.dekorate.prometheus.model.EndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Endpoint(), validationEnabled);
  }
  public EndpointBuilder(io.dekorate.prometheus.model.EndpointFluent<?> fluent,io.dekorate.prometheus.model.Endpoint instance) {
    this(fluent, instance, false);
  }
  public EndpointBuilder(io.dekorate.prometheus.model.EndpointFluent<?> fluent,io.dekorate.prometheus.model.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPort(instance.getPort()); 
    fluent.withPath(instance.getPath()); 
    fluent.withInterval(instance.getInterval()); 
    fluent.withHonorLabels(instance.isHonorLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public EndpointBuilder(io.dekorate.prometheus.model.Endpoint instance) {
    this(instance,false);
  }
  public EndpointBuilder(io.dekorate.prometheus.model.Endpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPort(instance.getPort()); 
    this.withPath(instance.getPath()); 
    this.withInterval(instance.getInterval()); 
    this.withHonorLabels(instance.isHonorLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  io.dekorate.prometheus.model.EndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.dekorate.prometheus.model.Endpoint build() {
    Endpoint buildable = new Endpoint(fluent.getPort(),fluent.getPath(),fluent.getInterval(),fluent.isHonorLabels());
    return buildable;
  }
  
}