package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder> implements VisitableBuilder<io.dekorate.prometheus.model.ServiceMonitorSpec,io.dekorate.prometheus.model.ServiceMonitorSpecBuilder>{
  public ServiceMonitorSpecBuilder() {
    this(false);
  }
  public ServiceMonitorSpecBuilder(Boolean validationEnabled) {
    this(new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorSpecBuilder(io.dekorate.prometheus.model.ServiceMonitorSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceMonitorSpec(), validationEnabled);
  }
  public ServiceMonitorSpecBuilder(io.dekorate.prometheus.model.ServiceMonitorSpecFluent<?> fluent,io.dekorate.prometheus.model.ServiceMonitorSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorSpecBuilder(io.dekorate.prometheus.model.ServiceMonitorSpecFluent<?> fluent,io.dekorate.prometheus.model.ServiceMonitorSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSelector(instance.getSelector()); 
    fluent.withEndpoints(instance.getEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorSpecBuilder(io.dekorate.prometheus.model.ServiceMonitorSpec instance) {
    this(instance,false);
  }
  public ServiceMonitorSpecBuilder(io.dekorate.prometheus.model.ServiceMonitorSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withSelector(instance.getSelector()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.validationEnabled = validationEnabled; 
  }
  io.dekorate.prometheus.model.ServiceMonitorSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.dekorate.prometheus.model.ServiceMonitorSpec build() {
    ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getSelector(),fluent.getEndpoints());
    return buildable;
  }
  
}