package io.dekorate.prometheus.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceMonitorBuilder extends ServiceMonitorFluentImpl<ServiceMonitorBuilder> implements VisitableBuilder<io.dekorate.prometheus.model.ServiceMonitor,io.dekorate.prometheus.model.ServiceMonitorBuilder>{
  public ServiceMonitorBuilder() {
    this(false);
  }
  public ServiceMonitorBuilder(Boolean validationEnabled) {
    this(new ServiceMonitor(), validationEnabled);
  }
  public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceMonitorBuilder(io.dekorate.prometheus.model.ServiceMonitorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceMonitor(), validationEnabled);
  }
  public ServiceMonitorBuilder(io.dekorate.prometheus.model.ServiceMonitorFluent<?> fluent,io.dekorate.prometheus.model.ServiceMonitor instance) {
    this(fluent, instance, false);
  }
  public ServiceMonitorBuilder(io.dekorate.prometheus.model.ServiceMonitorFluent<?> fluent,io.dekorate.prometheus.model.ServiceMonitor instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceMonitorBuilder(io.dekorate.prometheus.model.ServiceMonitor instance) {
    this(instance,false);
  }
  public ServiceMonitorBuilder(io.dekorate.prometheus.model.ServiceMonitor instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties()); 
    this.validationEnabled = validationEnabled; 
  }
  io.dekorate.prometheus.model.ServiceMonitorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.dekorate.prometheus.model.ServiceMonitor build() {
    ServiceMonitor buildable = new ServiceMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getAdditionalProperties());
    return buildable;
  }
  
}