/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.config;

import io.dekorate.prometheus.config.EditableServiceMonitorConfig;
import io.dekorate.prometheus.config.ServiceMonitorConfig;
import io.dekorate.prometheus.config.ServiceMonitorConfigFluent;
import io.dekorate.prometheus.config.ServiceMonitorConfigFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ServiceMonitorConfigBuilder
extends ServiceMonitorConfigFluentImpl<ServiceMonitorConfigBuilder>
implements VisitableBuilder<ServiceMonitorConfig, ServiceMonitorConfigBuilder> {
    ServiceMonitorConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorConfigBuilder() {
        this(true);
    }

    public ServiceMonitorConfigBuilder(Boolean validationEnabled) {
        this(new ServiceMonitorConfig(), validationEnabled);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceMonitorConfig(), validationEnabled);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent, ServiceMonitorConfig instance) {
        this(fluent, instance, true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent, ServiceMonitorConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withPort(instance.getPort());
        fluent.withPath(instance.getPath());
        fluent.withInterval(instance.getInterval());
        fluent.withHonorLabels(instance.getHonorLabels());
        this.validationEnabled = validationEnabled;
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfig instance) {
        this(instance, (Boolean)true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withPort(instance.getPort());
        this.withPath(instance.getPath());
        this.withInterval(instance.getInterval());
        this.withHonorLabels(instance.getHonorLabels());
        this.validationEnabled = validationEnabled;
    }

    public EditableServiceMonitorConfig build() {
        EditableServiceMonitorConfig buildable = new EditableServiceMonitorConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getPort(), this.fluent.getPath(), this.fluent.getInterval(), this.fluent.getHonorLabels());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorConfigBuilder that = (ServiceMonitorConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

