package io.dekorate.prometheus.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EndpointFluentImpl<A extends EndpointFluent<A>> extends BaseFluent<A> implements EndpointFluent<A> {

    private String port;
    private String path;
    private String interval;
    private boolean honorLabels;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withPort(instance.getPort()); 
        this.withPath(instance.getPath()); 
        this.withInterval(instance.getInterval()); 
        this.withHonorLabels(instance.isHonorLabels()); 
    }

    public String getPort() {
        return this.port;
    }

    public A withPort(String port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuilder arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuffer arg1) {
        return (A)withPort(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval=interval; return (A) this;
    }

    public Boolean hasInterval() {
        return this.interval != null;
    }

    public A withNewInterval(String arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuilder arg1) {
        return (A)withInterval(new String(arg1));
    }

    public A withNewInterval(StringBuffer arg1) {
        return (A)withInterval(new String(arg1));
    }

    public boolean isHonorLabels() {
        return this.honorLabels;
    }

    public A withHonorLabels(boolean honorLabels) {
        this.honorLabels=honorLabels; return (A) this;
    }

    public Boolean hasHonorLabels() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndpointFluentImpl that = (EndpointFluentImpl) o;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (interval != null ? !interval.equals(that.interval) :that.interval != null) return false;
        if (honorLabels != that.honorLabels) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
    }

}
