package io.dekorate.prometheus.config;

import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ServiceMonitorConfigFluentImpl<A extends ServiceMonitorConfigFluent<A>> extends ConfigurationFluentImpl<A> implements ServiceMonitorConfigFluent<A> {

    private String port = "http";
    private String path = "/metrics";
    private int interval = 10;
    private boolean honorLabels = false;

    public ServiceMonitorConfigFluentImpl() {
    }

    public ServiceMonitorConfigFluentImpl(ServiceMonitorConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withPort(instance.getPort()); 
        this.withPath(instance.getPath()); 
        this.withInterval(instance.getInterval()); 
        this.withHonorLabels(instance.isHonorLabels()); 
    }

    public String getPort() {
        return this.port;
    }

    public A withPort(String port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(String arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuilder arg1) {
        return (A)withPort(new String(arg1));
    }

    public A withNewPort(StringBuffer arg1) {
        return (A)withPort(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public int getInterval() {
        return this.interval;
    }

    public A withInterval(int interval) {
        this.interval=interval; return (A) this;
    }

    public Boolean hasInterval() {
        return true;
    }

    public boolean isHonorLabels() {
        return this.honorLabels;
    }

    public A withHonorLabels(boolean honorLabels) {
        this.honorLabels=honorLabels; return (A) this;
    }

    public Boolean hasHonorLabels() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceMonitorConfigFluentImpl that = (ServiceMonitorConfigFluentImpl) o;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (interval != that.interval) return false;
        if (honorLabels != that.honorLabels) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
    }

}
