/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import java.util.Map;
import java.util.Objects;

public class ServiceMonitorConfig
extends Configuration {
    private String port = "http";
    private String path = "/metrics";
    private int interval = 10;
    private boolean honorLabels = false;

    public ServiceMonitorConfig() {
    }

    public ServiceMonitorConfig(Project project, Map<ConfigKey, Object> attributes, String port, String path, int interval, boolean honorLabels) {
        super(project, attributes);
        this.port = port != null ? port : "http";
        this.path = path != null ? path : "/metrics";
        this.interval = interval;
        this.honorLabels = honorLabels;
    }

    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isHonorLabels() {
        return this.honorLabels;
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
        return new ServiceMonitorConfigBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceMonitorConfig that = (ServiceMonitorConfig)((Object)o);
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.interval != that.interval) {
            return false;
        }
        return this.honorLabels == that.honorLabels;
    }

    public int hashCode() {
        return Objects.hash(this.port, this.path, this.interval, this.honorLabels, super.hashCode());
    }
}

