package io.dekorate.prometheus.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorConfigBuilder extends ServiceMonitorConfigFluentImpl<ServiceMonitorConfigBuilder> implements VisitableBuilder<ServiceMonitorConfig,ServiceMonitorConfigBuilder> {

    ServiceMonitorConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorConfigBuilder() {
        this(true);
    }

    public ServiceMonitorConfigBuilder(Boolean validationEnabled) {
        this(new ServiceMonitorConfig(), validationEnabled);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceMonitorConfig(), validationEnabled);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent,ServiceMonitorConfig instance) {
        this(fluent, instance, true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfigFluent<?> fluent,ServiceMonitorConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withPort(instance.getPort()); 
        fluent.withPath(instance.getPath()); 
        fluent.withInterval(instance.getInterval()); 
        fluent.withHonorLabels(instance.isHonorLabels()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfig instance) {
        this(instance,true);
    }

    public ServiceMonitorConfigBuilder(ServiceMonitorConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withPort(instance.getPort()); 
        this.withPath(instance.getPath()); 
        this.withInterval(instance.getInterval()); 
        this.withHonorLabels(instance.isHonorLabels()); 
        this.validationEnabled = validationEnabled; 
    }

    public EditableServiceMonitorConfig build() {
        EditableServiceMonitorConfig buildable = new EditableServiceMonitorConfig(fluent.getProject(),fluent.getAttributes(),fluent.getPort(),fluent.getPath(),fluent.getInterval(),fluent.isHonorLabels());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceMonitorConfigBuilder that = (ServiceMonitorConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
