package io.dekorate.prometheus.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorSpecBuilder extends ServiceMonitorSpecFluentImpl<ServiceMonitorSpecBuilder> implements VisitableBuilder<ServiceMonitorSpec,ServiceMonitorSpecBuilder>{

    ServiceMonitorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorSpecBuilder(){
            this(true);
    }
    public ServiceMonitorSpecBuilder(Boolean validationEnabled){
            this(new ServiceMonitorSpec(), validationEnabled);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceMonitorSpec(), validationEnabled);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance){
            this(fluent, instance, true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpecFluent<?> fluent,ServiceMonitorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance){
            this(instance,true);
    }
    public ServiceMonitorSpecBuilder(ServiceMonitorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceMonitorSpec build(){
            ServiceMonitorSpec buildable = new ServiceMonitorSpec(fluent.getSelector(),fluent.getEndpoints());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceMonitorSpecBuilder that = (ServiceMonitorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
