package io.dekorate.prometheus.model;

import io.dekorate.deps.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.dekorate.deps.javax.validation.constraints.NotNull;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaFluentImpl;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.dekorate.deps.javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public class ServiceMonitorFluentImpl<A extends ServiceMonitorFluent<A>> extends io.dekorate.deps.kubernetes.api.builder.BaseFluent<A> implements ServiceMonitorFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServiceMonitorSpecBuilder spec;
    private Map<String,Object> additionalProperties;

    public ServiceMonitorFluentImpl(){
    }
    public ServiceMonitorFluentImpl(ServiceMonitor instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withAdditionalProperties(instance.getAdditionalProperties()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ServiceMonitorFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ServiceMonitorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ServiceMonitorFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceMonitorSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ServiceMonitorSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ServiceMonitorSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new ServiceMonitorSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ServiceMonitorFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ServiceMonitorFluent.SpecNested<A> withNewSpecLike(ServiceMonitorSpec item){
            return new SpecNestedImpl(item);
    }

    public ServiceMonitorFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ServiceMonitorFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceMonitorSpecBuilder().build());
    }

    public ServiceMonitorFluent.SpecNested<A> editOrNewSpecLike(ServiceMonitorSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public A addToAdditionalProperties(String key,Object value){
            if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
    }

    public A addToAdditionalProperties(Map<String,Object> map){
            if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
    }

    public A removeFromAdditionalProperties(String key){
            if(this.additionalProperties == null) { return (A) this; }
            if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String,Object> map){
            if(this.additionalProperties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getAdditionalProperties(){
            return this.additionalProperties;
    }

    public A withAdditionalProperties(Map<String,Object> additionalProperties){
            if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap<String,Object>(additionalProperties);} return (A) this;
    }

    public Boolean hasAdditionalProperties(){
            return this.additionalProperties != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServiceMonitorFluentImpl that = (ServiceMonitorFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceMonitorFluent.MetadataNested<N>> implements ServiceMonitorFluent.MetadataNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ServiceMonitorFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ServiceMonitorSpecFluentImpl<ServiceMonitorFluent.SpecNested<N>> implements ServiceMonitorFluent.SpecNested<N>,io.dekorate.deps.kubernetes.api.builder.Nested<N>{

            private final ServiceMonitorSpecBuilder builder;
    
            SpecNestedImpl(ServiceMonitorSpec item){
                    this.builder = new ServiceMonitorSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ServiceMonitorSpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceMonitorFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
