package io.dekorate.prometheus.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceMonitorBuilder extends ServiceMonitorFluentImpl<ServiceMonitorBuilder> implements VisitableBuilder<ServiceMonitor,ServiceMonitorBuilder>{

    ServiceMonitorFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceMonitorBuilder(){
            this(true);
    }
    public ServiceMonitorBuilder(Boolean validationEnabled){
            this(new ServiceMonitor(), validationEnabled);
    }
    public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceMonitor(), validationEnabled);
    }
    public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,ServiceMonitor instance){
            this(fluent, instance, true);
    }
    public ServiceMonitorBuilder(ServiceMonitorFluent<?> fluent,ServiceMonitor instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withAdditionalProperties(instance.getAdditionalProperties()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceMonitorBuilder(ServiceMonitor instance){
            this(instance,true);
    }
    public ServiceMonitorBuilder(ServiceMonitor instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withAdditionalProperties(instance.getAdditionalProperties()); 
            this.validationEnabled = validationEnabled; 
    }

    public ServiceMonitor build(){
            ServiceMonitor buildable = new ServiceMonitor(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getAdditionalProperties());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceMonitorBuilder that = (ServiceMonitorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
