/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.decorator;

import io.dekorate.deps.kubernetes.api.builder.TypedVisitor;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.prometheus.model.EndpointBuilder;
import io.dekorate.prometheus.model.ServiceMonitorBuilder;

public class EndpointPathDecorator
extends Decorator<ServiceMonitorBuilder> {
    private final String name;
    private final String port;
    private final String path;

    public EndpointPathDecorator(String name, String port, String path) {
        this.name = name;
        this.port = port;
        this.path = path;
    }

    public void visit(ServiceMonitorBuilder serviceMonitor) {
        if (this.name.equals(serviceMonitor.getMetadata().getName())) {
            serviceMonitor.accept((Visitor)new TypedVisitor<EndpointBuilder>(){

                public void visit(EndpointBuilder endpoint) {
                    if (EndpointPathDecorator.this.port.equals(endpoint.getPort())) {
                        endpoint.withPath(EndpointPathDecorator.this.path);
                    }
                }
            });
        }
    }
}

