package io.dekorate.prometheus.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointBuilder extends EndpointFluentImpl<EndpointBuilder> implements VisitableBuilder<Endpoint,EndpointBuilder> {

    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() { 
        this(true);
    }


    public EndpointBuilder(Boolean validationEnabled) { 
        this(new Endpoint(), validationEnabled);
    }


    public EndpointBuilder(EndpointFluent<?> fluent) { 
        this(fluent, true);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Endpoint(), validationEnabled);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance) { 
        this(fluent, instance, true);
    }


    public EndpointBuilder(EndpointFluent<?> fluent,Endpoint instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withPort(instance.getPort()); 
        fluent.withPath(instance.getPath()); 
        fluent.withInterval(instance.getInterval()); 
        fluent.withHonorLabels(instance.isHonorLabels()); 
        this.validationEnabled = validationEnabled; 
    }


    public EndpointBuilder(Endpoint instance) { 
        this(instance,true);
    }


    public EndpointBuilder(Endpoint instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withPort(instance.getPort()); 
        this.withPath(instance.getPath()); 
        this.withInterval(instance.getInterval()); 
        this.withHonorLabels(instance.isHonorLabels()); 
        this.validationEnabled = validationEnabled; 
    }


    public Endpoint build() {
        Endpoint buildable = new Endpoint(fluent.getPort(),fluent.getPath(),fluent.getInterval(),fluent.isHonorLabels());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointBuilder that = (EndpointBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
