package io.dekorate.prometheus.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class ServiceMonitorConfig extends Configuration {

    private String port = "http";
    private String path = "/metrics";
    private int interval = 10;
    private boolean honorLabels = false;

    public ServiceMonitorConfig() { 
    }


    public ServiceMonitorConfig(Project project,Map<ConfigKey,Object> attributes,String port,String path,int interval,boolean honorLabels) { 
        super(project, attributes);
        this.port = port != null ? port : "http";
        this.path = path != null ? path : "/metrics";
        this.interval = interval;
        this.honorLabels = honorLabels;
    }


    public String getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isHonorLabels() {
        return this.honorLabels;
    }

    public static ServiceMonitorConfigBuilder newServiceMonitorConfigBuilder() {
        return new io.dekorate.prometheus.config.ServiceMonitorConfigBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceMonitorConfig that = (ServiceMonitorConfig) o;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (interval != that.interval) return false;
        if (honorLabels != that.honorLabels) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(port,  path,  interval,  honorLabels,  super.hashCode());
    }

}
