package io.dekorate.prometheus.adapter;

import java.nio.file.Path;
import io.dekorate.prometheus.config.ServiceMonitorConfig;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import java.lang.String;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import java.lang.Object;
import java.util.List;
import io.dekorate.prometheus.annotation.EnableServiceMonitor;
import io.dekorate.project.ScmInfo;
import java.util.Map;

public class ServiceMonitorConfigAdapter {


    public static ServiceMonitorConfig adapt(EnableServiceMonitor instance) {
        return newBuilder(instance).build();
    }

    public static ServiceMonitorConfigBuilder newBuilder(EnableServiceMonitor instance) {
        return new ServiceMonitorConfigBuilder(new io.dekorate.prometheus.config.ServiceMonitorConfig(null,
            null,
            instance.port(),
            instance.path(),
            instance.interval(),
            instance.honorLabels()));
    }

    public static ServiceMonitorConfig adapt(Map map) {
        return new io.dekorate.prometheus.config.ServiceMonitorConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("port", "http") : "http"),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("path", "/metrics") : "/metrics"),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("interval","10") : "10")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("honorLabels","false") : "false")));
    }

    public static ServiceMonitorConfigBuilder newBuilder(Map map) {
        return new ServiceMonitorConfigBuilder(new io.dekorate.prometheus.config.ServiceMonitorConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("port", "http") : "http"),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("path", "/metrics") : "/metrics"),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("interval","10") : "10")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("honorLabels","false") : "false"))));
    }

    public static String[] toStringArray(Object o) {
                if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

    }

}
