/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.prometheus.adapter.ServiceMonitorConfigAdapter;
import io.dekorate.prometheus.annotation.EnableServiceMonitor;
import io.dekorate.prometheus.config.ServiceMonitorConfig;
import io.dekorate.prometheus.config.ServiceMonitorConfigBuilder;
import io.dekorate.prometheus.handler.ServiceMonitorHandler;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface ServiceMonitorGenerator
extends Generator,
WithSession {
    default public String getKey() {
        return "servicemonitor";
    }

    default public Class<? extends Annotation> getAnnotation() {
        return EnableServiceMonitor.class;
    }

    default public void add(Map map) {
        this.on((ConfigurationSupplier<ServiceMonitorConfig>)new PropertyConfiguration((VisitableBuilder)ServiceMonitorConfigAdapter.newBuilder(this.propertiesMap(map, EnableServiceMonitor.class))));
    }

    default public void add(Element element) {
        EnableServiceMonitor serviceMonitor = element.getAnnotation(EnableServiceMonitor.class);
        this.on((ConfigurationSupplier<ServiceMonitorConfig>)(serviceMonitor != null ? new AnnotationConfiguration((VisitableBuilder)ServiceMonitorConfigAdapter.newBuilder(serviceMonitor)) : new AnnotationConfiguration((VisitableBuilder)new ServiceMonitorConfigBuilder())));
    }

    default public void on(ConfigurationSupplier<ServiceMonitorConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.handlers().add(new ServiceMonitorHandler(session.resources()));
    }
}

