package io.dekorate.prometheus.model;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.dekorate.deps.kubernetes.api.builder.Fluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import java.lang.String;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.dekorate.deps.javax.validation.constraints.NotNull;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.dekorate.deps.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ServiceMonitorFluent<A extends ServiceMonitorFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceMonitorFluent.MetadataNested<A> withNewMetadata();
    public ServiceMonitorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceMonitorFluent.MetadataNested<A> editMetadata();
    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceMonitorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceMonitorSpec getSpec();
    public ServiceMonitorSpec buildSpec();
    public A withSpec(ServiceMonitorSpec spec);
    public Boolean hasSpec();
    public ServiceMonitorFluent.SpecNested<A> withNewSpec();
    public ServiceMonitorFluent.SpecNested<A> withNewSpecLike(ServiceMonitorSpec item);
    public ServiceMonitorFluent.SpecNested<A> editSpec();
    public ServiceMonitorFluent.SpecNested<A> editOrNewSpec();
    public ServiceMonitorFluent.SpecNested<A> editOrNewSpecLike(ServiceMonitorSpec item);
    public A addToAdditionalProperties(String key,Object value);
    public A addToAdditionalProperties(Map<String,Object> map);
    public A removeFromAdditionalProperties(String key);
    public A removeFromAdditionalProperties(Map<String,Object> map);
    public Map<String,Object> getAdditionalProperties();
    public A withAdditionalProperties(Map<String,Object> additionalProperties);
    public Boolean hasAdditionalProperties();

    public interface MetadataNested<N> extends io.dekorate.deps.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceMonitorFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.dekorate.deps.kubernetes.api.builder.Nested<N>,ServiceMonitorSpecFluent<ServiceMonitorFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
