/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.prometheus.model;

import io.dekorate.deps.kubernetes.api.builder.BaseFluent;
import io.dekorate.deps.kubernetes.api.builder.Nested;
import io.dekorate.deps.kubernetes.api.builder.Predicate;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluent;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorFluentImpl;
import io.dekorate.prometheus.model.Endpoint;
import io.dekorate.prometheus.model.EndpointBuilder;
import io.dekorate.prometheus.model.EndpointFluentImpl;
import io.dekorate.prometheus.model.ServiceMonitorSpec;
import io.dekorate.prometheus.model.ServiceMonitorSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServiceMonitorSpecFluentImpl<A extends ServiceMonitorSpecFluent<A>>
extends BaseFluent<A>
implements ServiceMonitorSpecFluent<A> {
    private LabelSelectorBuilder selector;
    private List<EndpointBuilder> endpoints;

    public ServiceMonitorSpecFluentImpl() {
    }

    public ServiceMonitorSpecFluentImpl(ServiceMonitorSpec instance) {
        this.withSelector(instance.getSelector());
        this.withEndpoints(instance.getEndpoints());
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ServiceMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        this._visitables.get((Object)"endpoints").add(index >= 0 ? index : this._visitables.get((Object)"endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"endpoints").size()) {
            this._visitables.get((Object)"endpoints").add(builder);
        } else {
            this._visitables.get((Object)"endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(Endpoint ... items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get((Object)"endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        List visitables = this._visitables.get((Object)"endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Endpoint> getEndpoints() {
        return ServiceMonitorSpecFluentImpl.build(this.endpoints);
    }

    @Override
    public List<Endpoint> buildEndpoints() {
        return ServiceMonitorSpecFluentImpl.build(this.endpoints);
    }

    @Override
    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get((Object)"endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public A addNewEndpoint(String port, String path, String interval, boolean honorLabels) {
        return this.addToEndpoints(new Endpoint(port, path, interval, honorLabels));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceMonitorSpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.apply((Object)this.endpoints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceMonitorSpecFluentImpl that = (ServiceMonitorSpecFluentImpl)o;
        if (this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null) {
            return false;
        }
        return !(this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null);
    }

    public class EndpointsNestedImpl<N>
    extends EndpointFluentImpl<ServiceMonitorSpecFluent.EndpointsNested<N>>
    implements ServiceMonitorSpecFluent.EndpointsNested<N>,
    Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceMonitorSpecFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ServiceMonitorSpecFluent.SelectorNested<N>>
    implements ServiceMonitorSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)ServiceMonitorSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

