package io.dekorate.option.config;

import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VcsConfigFluent<A extends VcsConfigFluent<A>> extends ConfigurationFluent<A>{
  public VcsConfigFluent() {
  }
  
  public VcsConfigFluent(VcsConfig instance) {
    this.copyInstance(instance);
  }
  private String remote;
  private Boolean httpsPreferred;
  
  protected void copyInstance(VcsConfig instance) {
    instance = (instance != null ? instance : new VcsConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withRemote(instance.getRemote());
          this.withHttpsPreferred(instance.getHttpsPreferred());
        }
  }
  
  public String getRemote() {
    return this.remote;
  }
  
  public A withRemote(String remote) {
    this.remote = remote;
    return (A) this;
  }
  
  public boolean hasRemote() {
    return this.remote != null;
  }
  
  public Boolean getHttpsPreferred() {
    return this.httpsPreferred;
  }
  
  public A withHttpsPreferred(Boolean httpsPreferred) {
    this.httpsPreferred = httpsPreferred;
    return (A) this;
  }
  
  public boolean hasHttpsPreferred() {
    return this.httpsPreferred != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VcsConfigFluent that = (VcsConfigFluent) o;
    if (!java.util.Objects.equals(remote, that.remote)) return false;
    if (!java.util.Objects.equals(httpsPreferred, that.httpsPreferred)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(remote,  httpsPreferred,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (remote != null) { sb.append("remote:"); sb.append(remote + ","); }
    if (httpsPreferred != null) { sb.append("httpsPreferred:"); sb.append(httpsPreferred); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withHttpsPreferred() {
    return withHttpsPreferred(true);
  }
  

}