package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.option.annotation.GarbageCollector;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class JvmConfig extends Configuration{
  public JvmConfig() {
  }
  
  public JvmConfig(Project project,Map<ConfigKey,Object> attributes,Integer xms,Integer xmx,Boolean server,Boolean useStringDeduplication,Boolean preferIPv4Stack,Boolean heapDumpOnOutOfMemoryError,Boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom) {
    super(project, attributes);
    this.xms = xms;
    this.xmx = xmx;
    this.server = server;
    this.useStringDeduplication = useStringDeduplication;
    this.preferIPv4Stack = preferIPv4Stack;
    this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
    this.useGCOverheadLimit = useGCOverheadLimit;
    this.gc = gc;
    this.secureRandom = secureRandom;
  }
  private Integer xms;
  private Integer xmx;
  private Boolean server;
  private Boolean useStringDeduplication;
  private Boolean preferIPv4Stack;
  private Boolean heapDumpOnOutOfMemoryError;
  private Boolean useGCOverheadLimit;
  private GarbageCollector gc;
  private SecureRandomSource secureRandom;
  
  
  /**
   * Starting heap size in megabytes.
   * @return The starting heap size in megabytes, or 0 if undefined.
   */
  public Integer getXms() {
    return this.xms;
  }
  
  
  /**
   * Maxium heap size in megabytes.
   * @return The maximum heap size in megabytes, or 0 if undefined.
   */
  public Integer getXmx() {
    return this.xmx;
  }
  
  
  /**
   * Server Flag.
   * @return True if server flag is used.
   */
  public Boolean getServer() {
    return this.server;
  }
  
  
  /**
   * Server Flag.
   * @return True if server flag is used.
   */
  public boolean isServer() {
    return this.server != null &&  this.server;
  }
  
  
  /**
   * String deduplication flag.
   * @return True if string deduplication is enabled.
   */
  public Boolean getUseStringDeduplication() {
    return this.useStringDeduplication;
  }
  
  
  /**
   * String deduplication flag.
   * @return True if string deduplication is enabled.
   */
  public boolean isUseStringDeduplication() {
    return this.useStringDeduplication != null &&  this.useStringDeduplication;
  }
  
  
  /**
   * Prefer IPv4 stack.
   * @return True if preferred.
   */
  public Boolean getPreferIPv4Stack() {
    return this.preferIPv4Stack;
  }
  
  
  /**
   * Prefer IPv4 stack.
   * @return True if preferred.
   */
  public boolean isPreferIPv4Stack() {
    return this.preferIPv4Stack != null &&  this.preferIPv4Stack;
  }
  
  
  /**
   * Instructs the JVM to dump heap into physical file in case of OutOfMemoryError
   * @return True, if enabled.
   */
  public Boolean getHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError;
  }
  
  
  /**
   * Instructs the JVM to dump heap into physical file in case of OutOfMemoryError
   * @return True, if enabled.
   */
  public boolean isHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError != null &&  this.heapDumpOnOutOfMemoryError;
  }
  
  
  /**
   * Is a policy that limits the proportion of the VM’s time that is spent in GC before an OutOfMemory error is thrown.
   * @return True if enabled.
   */
  public Boolean getUseGCOverheadLimit() {
    return this.useGCOverheadLimit;
  }
  
  
  /**
   * Is a policy that limits the proportion of the VM’s time that is spent in GC before an OutOfMemory error is thrown.
   * @return True if enabled.
   */
  public boolean isUseGCOverheadLimit() {
    return this.useGCOverheadLimit != null &&  this.useGCOverheadLimit;
  }
  
  
  /**
   * Garbage Collector implementation.
   * @return The gc impl or Undefined if none is selected.
   */
  public GarbageCollector getGc() {
    return this.gc;
  }
  
  
  /**
   * The Secure random source to use.
   * This will determine -Djava.security.egd option.
   * @return The source to use. Defaults to undefined.
   */
  public SecureRandomSource getSecureRandom() {
    return this.secureRandom;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JvmConfig that = (JvmConfig) o;
    if (!java.util.Objects.equals(xms, that.xms)) return false;
    if (!java.util.Objects.equals(xmx, that.xmx)) return false;
    if (!java.util.Objects.equals(server, that.server)) return false;
    if (!java.util.Objects.equals(useStringDeduplication, that.useStringDeduplication)) return false;
    if (!java.util.Objects.equals(preferIPv4Stack, that.preferIPv4Stack)) return false;
    if (!java.util.Objects.equals(heapDumpOnOutOfMemoryError, that.heapDumpOnOutOfMemoryError)) return false;
    if (!java.util.Objects.equals(useGCOverheadLimit, that.useGCOverheadLimit)) return false;
    if (!java.util.Objects.equals(gc, that.gc)) return false;
    if (!java.util.Objects.equals(secureRandom, that.secureRandom)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
  }
  

}