package io.dekorate.option.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.String;
import java.lang.Boolean;
import io.dekorate.option.annotation.GarbageCollector;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JvmConfigFluent<A extends JvmConfigFluent<A>> extends ConfigurationFluent<A>{
  public JvmConfigFluent() {
  }
  public JvmConfigFluent(JvmConfig instance) {
    instance = (instance != null ? instance : new JvmConfig());

    if (instance != null) {
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
      this.withXms(instance.getXms());
      this.withXmx(instance.getXmx());
      this.withServer(instance.getServer());
      this.withUseStringDeduplication(instance.getUseStringDeduplication());
      this.withPreferIPv4Stack(instance.getPreferIPv4Stack());
      this.withHeapDumpOnOutOfMemoryError(instance.getHeapDumpOnOutOfMemoryError());
      this.withUseGCOverheadLimit(instance.getUseGCOverheadLimit());
      this.withGc(instance.getGc());
      this.withSecureRandom(instance.getSecureRandom());
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
    }
  }
  private Integer xms;
  private Integer xmx;
  private Boolean server;
  private Boolean useStringDeduplication;
  private Boolean preferIPv4Stack;
  private Boolean heapDumpOnOutOfMemoryError;
  private Boolean useGCOverheadLimit;
  private GarbageCollector gc;
  private SecureRandomSource secureRandom;
  public Integer getXms() {
    return this.xms;
  }
  public A withXms(Integer xms) {
    this.xms=xms; return (A) this;
  }
  public boolean hasXms() {
    return this.xms != null;
  }
  public Integer getXmx() {
    return this.xmx;
  }
  public A withXmx(Integer xmx) {
    this.xmx=xmx; return (A) this;
  }
  public boolean hasXmx() {
    return this.xmx != null;
  }
  public Boolean getServer() {
    return this.server;
  }
  public A withServer(Boolean server) {
    this.server=server; return (A) this;
  }
  public boolean hasServer() {
    return this.server != null;
  }
  public Boolean getUseStringDeduplication() {
    return this.useStringDeduplication;
  }
  public A withUseStringDeduplication(Boolean useStringDeduplication) {
    this.useStringDeduplication=useStringDeduplication; return (A) this;
  }
  public boolean hasUseStringDeduplication() {
    return this.useStringDeduplication != null;
  }
  public Boolean getPreferIPv4Stack() {
    return this.preferIPv4Stack;
  }
  public A withPreferIPv4Stack(Boolean preferIPv4Stack) {
    this.preferIPv4Stack=preferIPv4Stack; return (A) this;
  }
  public boolean hasPreferIPv4Stack() {
    return this.preferIPv4Stack != null;
  }
  public Boolean getHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError;
  }
  public A withHeapDumpOnOutOfMemoryError(Boolean heapDumpOnOutOfMemoryError) {
    this.heapDumpOnOutOfMemoryError=heapDumpOnOutOfMemoryError; return (A) this;
  }
  public boolean hasHeapDumpOnOutOfMemoryError() {
    return this.heapDumpOnOutOfMemoryError != null;
  }
  public Boolean getUseGCOverheadLimit() {
    return this.useGCOverheadLimit;
  }
  public A withUseGCOverheadLimit(Boolean useGCOverheadLimit) {
    this.useGCOverheadLimit=useGCOverheadLimit; return (A) this;
  }
  public boolean hasUseGCOverheadLimit() {
    return this.useGCOverheadLimit != null;
  }
  public GarbageCollector getGc() {
    return this.gc;
  }
  public A withGc(GarbageCollector gc) {
    this.gc=gc; return (A) this;
  }
  public boolean hasGc() {
    return this.gc != null;
  }
  public SecureRandomSource getSecureRandom() {
    return this.secureRandom;
  }
  public A withSecureRandom(SecureRandomSource secureRandom) {
    this.secureRandom=secureRandom; return (A) this;
  }
  public boolean hasSecureRandom() {
    return this.secureRandom != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JvmConfigFluent that = (JvmConfigFluent) o;
    if (!java.util.Objects.equals(xms, that.xms)) return false;

    if (!java.util.Objects.equals(xmx, that.xmx)) return false;

    if (!java.util.Objects.equals(server, that.server)) return false;

    if (!java.util.Objects.equals(useStringDeduplication, that.useStringDeduplication)) return false;

    if (!java.util.Objects.equals(preferIPv4Stack, that.preferIPv4Stack)) return false;

    if (!java.util.Objects.equals(heapDumpOnOutOfMemoryError, that.heapDumpOnOutOfMemoryError)) return false;

    if (!java.util.Objects.equals(useGCOverheadLimit, that.useGCOverheadLimit)) return false;

    if (!java.util.Objects.equals(gc, that.gc)) return false;

    if (!java.util.Objects.equals(secureRandom, that.secureRandom)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (xms != null) { sb.append("xms:"); sb.append(xms + ","); }
    if (xmx != null) { sb.append("xmx:"); sb.append(xmx + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (useStringDeduplication != null) { sb.append("useStringDeduplication:"); sb.append(useStringDeduplication + ","); }
    if (preferIPv4Stack != null) { sb.append("preferIPv4Stack:"); sb.append(preferIPv4Stack + ","); }
    if (heapDumpOnOutOfMemoryError != null) { sb.append("heapDumpOnOutOfMemoryError:"); sb.append(heapDumpOnOutOfMemoryError + ","); }
    if (useGCOverheadLimit != null) { sb.append("useGCOverheadLimit:"); sb.append(useGCOverheadLimit + ","); }
    if (gc != null) { sb.append("gc:"); sb.append(gc + ","); }
    if (secureRandom != null) { sb.append("secureRandom:"); sb.append(secureRandom); }
    sb.append("}");
    return sb.toString();
  }
  public A withServer() {
    return withServer(true);
  }
  public A withUseStringDeduplication() {
    return withUseStringDeduplication(true);
  }
  public A withPreferIPv4Stack() {
    return withPreferIPv4Stack(true);
  }
  public A withHeapDumpOnOutOfMemoryError() {
    return withHeapDumpOnOutOfMemoryError(true);
  }
  public A withUseGCOverheadLimit() {
    return withUseGCOverheadLimit(true);
  }
  
}