/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.option.annotation.GarbageCollector;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.option.config.JvmConfig;
import java.util.Objects;

public class JvmConfigFluent<A extends JvmConfigFluent<A>>
extends ConfigurationFluent<A> {
    private Integer xms;
    private Integer xmx;
    private Boolean server;
    private Boolean useStringDeduplication;
    private Boolean preferIPv4Stack;
    private Boolean heapDumpOnOutOfMemoryError;
    private Boolean useGCOverheadLimit;
    private GarbageCollector gc;
    private SecureRandomSource secureRandom;

    public JvmConfigFluent() {
    }

    public JvmConfigFluent(JvmConfig instance) {
        JvmConfig jvmConfig = instance = instance != null ? instance : new JvmConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withXms(instance.getXms());
            this.withXmx(instance.getXmx());
            this.withServer(instance.getServer());
            this.withUseStringDeduplication(instance.getUseStringDeduplication());
            this.withPreferIPv4Stack(instance.getPreferIPv4Stack());
            this.withHeapDumpOnOutOfMemoryError(instance.getHeapDumpOnOutOfMemoryError());
            this.withUseGCOverheadLimit(instance.getUseGCOverheadLimit());
            this.withGc(instance.getGc());
            this.withSecureRandom(instance.getSecureRandom());
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
        }
    }

    public Integer getXms() {
        return this.xms;
    }

    public A withXms(Integer xms) {
        this.xms = xms;
        return (A)((Object)this);
    }

    public boolean hasXms() {
        return this.xms != null;
    }

    public Integer getXmx() {
        return this.xmx;
    }

    public A withXmx(Integer xmx) {
        this.xmx = xmx;
        return (A)((Object)this);
    }

    public boolean hasXmx() {
        return this.xmx != null;
    }

    public Boolean getServer() {
        return this.server;
    }

    public A withServer(Boolean server) {
        this.server = server;
        return (A)((Object)this);
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public Boolean getUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public A withUseStringDeduplication(Boolean useStringDeduplication) {
        this.useStringDeduplication = useStringDeduplication;
        return (A)((Object)this);
    }

    public boolean hasUseStringDeduplication() {
        return this.useStringDeduplication != null;
    }

    public Boolean getPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public A withPreferIPv4Stack(Boolean preferIPv4Stack) {
        this.preferIPv4Stack = preferIPv4Stack;
        return (A)((Object)this);
    }

    public boolean hasPreferIPv4Stack() {
        return this.preferIPv4Stack != null;
    }

    public Boolean getHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public A withHeapDumpOnOutOfMemoryError(Boolean heapDumpOnOutOfMemoryError) {
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        return (A)((Object)this);
    }

    public boolean hasHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError != null;
    }

    public Boolean getUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public A withUseGCOverheadLimit(Boolean useGCOverheadLimit) {
        this.useGCOverheadLimit = useGCOverheadLimit;
        return (A)((Object)this);
    }

    public boolean hasUseGCOverheadLimit() {
        return this.useGCOverheadLimit != null;
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public A withGc(GarbageCollector gc) {
        this.gc = gc;
        return (A)((Object)this);
    }

    public boolean hasGc() {
        return this.gc != null;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public A withSecureRandom(SecureRandomSource secureRandom) {
        this.secureRandom = secureRandom;
        return (A)((Object)this);
    }

    public boolean hasSecureRandom() {
        return this.secureRandom != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmConfigFluent that = (JvmConfigFluent)((Object)o);
        if (!Objects.equals(this.xms, that.xms)) {
            return false;
        }
        if (!Objects.equals(this.xmx, that.xmx)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.useStringDeduplication, that.useStringDeduplication)) {
            return false;
        }
        if (!Objects.equals(this.preferIPv4Stack, that.preferIPv4Stack)) {
            return false;
        }
        if (!Objects.equals(this.heapDumpOnOutOfMemoryError, that.heapDumpOnOutOfMemoryError)) {
            return false;
        }
        if (!Objects.equals(this.useGCOverheadLimit, that.useGCOverheadLimit)) {
            return false;
        }
        if (!Objects.equals(this.gc, that.gc)) {
            return false;
        }
        return Objects.equals(this.secureRandom, that.secureRandom);
    }

    public int hashCode() {
        return Objects.hash(this.xms, this.xmx, this.server, this.useStringDeduplication, this.preferIPv4Stack, this.heapDumpOnOutOfMemoryError, this.useGCOverheadLimit, this.gc, this.secureRandom, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.xms != null) {
            sb.append("xms:");
            sb.append(this.xms + ",");
        }
        if (this.xmx != null) {
            sb.append("xmx:");
            sb.append(this.xmx + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.useStringDeduplication != null) {
            sb.append("useStringDeduplication:");
            sb.append(this.useStringDeduplication + ",");
        }
        if (this.preferIPv4Stack != null) {
            sb.append("preferIPv4Stack:");
            sb.append(this.preferIPv4Stack + ",");
        }
        if (this.heapDumpOnOutOfMemoryError != null) {
            sb.append("heapDumpOnOutOfMemoryError:");
            sb.append(this.heapDumpOnOutOfMemoryError + ",");
        }
        if (this.useGCOverheadLimit != null) {
            sb.append("useGCOverheadLimit:");
            sb.append(this.useGCOverheadLimit + ",");
        }
        if (this.gc != null) {
            sb.append("gc:");
            sb.append(this.gc + ",");
        }
        if (this.secureRandom != null) {
            sb.append("secureRandom:");
            sb.append(this.secureRandom);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withServer() {
        return this.withServer(true);
    }

    public A withUseStringDeduplication() {
        return this.withUseStringDeduplication(true);
    }

    public A withPreferIPv4Stack() {
        return this.withPreferIPv4Stack(true);
    }

    public A withHeapDumpOnOutOfMemoryError() {
        return this.withHeapDumpOnOutOfMemoryError(true);
    }

    public A withUseGCOverheadLimit() {
        return this.withUseGCOverheadLimit(true);
    }
}

