/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.ConfigurationGenerator;
import io.dekorate.SessionWriter;
import io.dekorate.WithProject;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.option.adapter.GeneratorConfigAdapter;
import io.dekorate.option.config.GeneratorConfig;
import io.dekorate.option.config.GeneratorConfigBuilder;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.File;
import java.util.Map;

public interface GeneratorConfigGenerator
extends ConfigurationGenerator,
WithProject {
    public static final String OPTIONS = "options";

    default public String getKey() {
        return OPTIONS;
    }

    default public Class<? extends Configuration> getConfigType() {
        return GeneratorConfig.class;
    }

    default public void addAnnotationConfiguration(Map map) {
        this.on((ConfigurationSupplier<GeneratorConfig>)new AnnotationConfiguration((VisitableBuilder)GeneratorConfigAdapter.newBuilder(this.propertiesMap(map, GeneratorConfig.class))));
    }

    default public void addPropertyConfiguration(Map map) {
        this.on((ConfigurationSupplier<GeneratorConfig>)new PropertyConfiguration((VisitableBuilder)GeneratorConfigAdapter.newBuilder(this.propertiesMap(map, GeneratorConfig.class))));
    }

    default public void on(ConfigurationSupplier<GeneratorConfig> config) {
        this.getConfigurationRegistry().add(config);
        GeneratorConfig c = (GeneratorConfig)config.get();
        this.configurePaths(c.getInputPath(), c.getOutputPath());
    }

    default public void configurePaths(String inputPath, String outputPath) {
        if (this.isInputPathValid(inputPath)) {
            this.applyToProject(p -> p.withDekorateInputDir(inputPath));
            this.getSession().getConfigurationRegistry().add(new ConfigurationSupplier((VisitableBuilder)new GeneratorConfigBuilder()));
        }
        if (this.isOutputPathValid(outputPath)) {
            this.resolve(outputPath).mkdirs();
            this.applyToProject(p -> p.withDekorateOutputDir(outputPath));
            this.getSession().setWriter((SessionWriter)new SimpleFileWriter(this.getProject().getBuildInfo().getClassOutputDir().resolve(this.getProject().getDekorateMetaDir()), this.resolve(outputPath).toPath()));
        }
    }

    default public boolean isInputPathValid(String path) {
        return Strings.isNotNullOrEmpty((String)path) && this.resolve(path).exists();
    }

    default public boolean isOutputPathValid(String path) {
        return Strings.isNotNullOrEmpty((String)path) && (this.resolve(path).exists() || this.resolve(path).mkdirs());
    }

    default public File resolve(String unixPath) {
        return new File(this.getProject().getBuildInfo().getClassOutputDir().toFile(), unixPath.replace('/', File.separatorChar));
    }
}

