package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class VcsConfigFluentImpl<A extends VcsConfigFluent<A>> extends ConfigurationFluentImpl<A> implements VcsConfigFluent<A> {

    private String remote;
    private Boolean httpsPreferred;

    public VcsConfigFluentImpl() {
    }

    public VcsConfigFluentImpl(VcsConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withRemote(instance.getRemote()); 
        this.withHttpsPreferred(instance.getHttpsPreferred()); 
    }

    public String getRemote() {
        return this.remote;
    }

    public A withRemote(String remote) {
        this.remote=remote; return (A) this;
    }

    public Boolean hasRemote() {
        return this.remote != null;
    }

    public A withNewRemote(String arg1) {
        return (A)withRemote(new String(arg1));
    }

    public A withNewRemote(StringBuilder arg1) {
        return (A)withRemote(new String(arg1));
    }

    public A withNewRemote(StringBuffer arg1) {
        return (A)withRemote(new String(arg1));
    }

    public Boolean getHttpsPreferred() {
        return this.httpsPreferred;
    }

    public A withHttpsPreferred(Boolean httpsPreferred) {
        this.httpsPreferred=httpsPreferred; return (A) this;
    }

    public Boolean hasHttpsPreferred() {
        return this.httpsPreferred != null;
    }

    public A withNewHttpsPreferred(String arg1) {
        return (A)withHttpsPreferred(new Boolean(arg1));
    }

    public A withNewHttpsPreferred(boolean arg1) {
        return (A)withHttpsPreferred(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VcsConfigFluentImpl that = (VcsConfigFluentImpl) o;
        if (remote != null ? !remote.equals(that.remote) :that.remote != null) return false;
        if (httpsPreferred != null ? !httpsPreferred.equals(that.httpsPreferred) :that.httpsPreferred != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(remote,  httpsPreferred,  super.hashCode());
    }

}
