package io.dekorate.option.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JvmConfigBuilder extends JvmConfigFluentImpl<JvmConfigBuilder> implements VisitableBuilder<JvmConfig,JvmConfigBuilder> {

    JvmConfigFluent<?> fluent;
    Boolean validationEnabled;

    public JvmConfigBuilder() {
        this(true);
    }

    public JvmConfigBuilder(Boolean validationEnabled) {
        this(new JvmConfig(), validationEnabled);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JvmConfig(), validationEnabled);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent,JvmConfig instance) {
        this(fluent, instance, true);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent,JvmConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withXms(instance.getXms()); 
        fluent.withXmx(instance.getXmx()); 
        fluent.withServer(instance.getServer()); 
        fluent.withUseStringDeduplication(instance.getUseStringDeduplication()); 
        fluent.withPreferIPv4Stack(instance.getPreferIPv4Stack()); 
        fluent.withHeapDumpOnOutOfMemoryError(instance.getHeapDumpOnOutOfMemoryError()); 
        fluent.withUseGCOverheadLimit(instance.getUseGCOverheadLimit()); 
        fluent.withGc(instance.getGc()); 
        fluent.withSecureRandom(instance.getSecureRandom()); 
        this.validationEnabled = validationEnabled; 
    }

    public JvmConfigBuilder(JvmConfig instance) {
        this(instance,true);
    }

    public JvmConfigBuilder(JvmConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withXms(instance.getXms()); 
        this.withXmx(instance.getXmx()); 
        this.withServer(instance.getServer()); 
        this.withUseStringDeduplication(instance.getUseStringDeduplication()); 
        this.withPreferIPv4Stack(instance.getPreferIPv4Stack()); 
        this.withHeapDumpOnOutOfMemoryError(instance.getHeapDumpOnOutOfMemoryError()); 
        this.withUseGCOverheadLimit(instance.getUseGCOverheadLimit()); 
        this.withGc(instance.getGc()); 
        this.withSecureRandom(instance.getSecureRandom()); 
        this.validationEnabled = validationEnabled; 
    }

    public EditableJvmConfig build() {
        EditableJvmConfig buildable = new EditableJvmConfig(fluent.getProject(),fluent.getAttributes(),fluent.getXms(),fluent.getXmx(),fluent.getServer(),fluent.getUseStringDeduplication(),fluent.getPreferIPv4Stack(),fluent.getHeapDumpOnOutOfMemoryError(),fluent.getUseGCOverheadLimit(),fluent.getGc(),fluent.getSecureRandom());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmConfigBuilder that = (JvmConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
