package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GeneratorConfigFluentImpl<A extends GeneratorConfigFluent<A>> extends ConfigurationFluentImpl<A> implements GeneratorConfigFluent<A> {

    private String inputPath;
    private String outputPath;

    public GeneratorConfigFluentImpl() {
    }

    public GeneratorConfigFluentImpl(GeneratorConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withInputPath(instance.getInputPath()); 
        this.withOutputPath(instance.getOutputPath()); 
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public A withInputPath(String inputPath) {
        this.inputPath=inputPath; return (A) this;
    }

    public Boolean hasInputPath() {
        return this.inputPath != null;
    }

    public A withNewInputPath(String arg1) {
        return (A)withInputPath(new String(arg1));
    }

    public A withNewInputPath(StringBuilder arg1) {
        return (A)withInputPath(new String(arg1));
    }

    public A withNewInputPath(StringBuffer arg1) {
        return (A)withInputPath(new String(arg1));
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public A withOutputPath(String outputPath) {
        this.outputPath=outputPath; return (A) this;
    }

    public Boolean hasOutputPath() {
        return this.outputPath != null;
    }

    public A withNewOutputPath(String arg1) {
        return (A)withOutputPath(new String(arg1));
    }

    public A withNewOutputPath(StringBuilder arg1) {
        return (A)withOutputPath(new String(arg1));
    }

    public A withNewOutputPath(StringBuffer arg1) {
        return (A)withOutputPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GeneratorConfigFluentImpl that = (GeneratorConfigFluentImpl) o;
        if (inputPath != null ? !inputPath.equals(that.inputPath) :that.inputPath != null) return false;
        if (outputPath != null ? !outputPath.equals(that.outputPath) :that.outputPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(inputPath,  outputPath,  super.hashCode());
    }

}
