package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.String;
import java.lang.Boolean;
import io.dekorate.option.annotation.GarbageCollector;

public class JvmConfigFluentImpl<A extends JvmConfigFluent<A>> extends ConfigurationFluentImpl<A> implements JvmConfigFluent<A> {

    private Integer xms;
    private Integer xmx;
    private Boolean server;
    private Boolean useStringDeduplication;
    private Boolean preferIPv4Stack;
    private Boolean heapDumpOnOutOfMemoryError;
    private Boolean useGCOverheadLimit;
    private GarbageCollector gc;
    private SecureRandomSource secureRandom;

    public JvmConfigFluentImpl() {
    }

    public JvmConfigFluentImpl(JvmConfig instance) {
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withXms(instance.getXms()); 
        this.withXmx(instance.getXmx()); 
        this.withServer(instance.getServer()); 
        this.withUseStringDeduplication(instance.getUseStringDeduplication()); 
        this.withPreferIPv4Stack(instance.getPreferIPv4Stack()); 
        this.withHeapDumpOnOutOfMemoryError(instance.getHeapDumpOnOutOfMemoryError()); 
        this.withUseGCOverheadLimit(instance.getUseGCOverheadLimit()); 
        this.withGc(instance.getGc()); 
        this.withSecureRandom(instance.getSecureRandom()); 
    }

    public Integer getXms() {
        return this.xms;
    }

    public A withXms(Integer xms) {
        this.xms=xms; return (A) this;
    }

    public Boolean hasXms() {
        return this.xms != null;
    }

    public A withNewXms(String arg1) {
        return (A)withXms(new Integer(arg1));
    }

    public A withNewXms(int arg1) {
        return (A)withXms(new Integer(arg1));
    }

    public Integer getXmx() {
        return this.xmx;
    }

    public A withXmx(Integer xmx) {
        this.xmx=xmx; return (A) this;
    }

    public Boolean hasXmx() {
        return this.xmx != null;
    }

    public A withNewXmx(String arg1) {
        return (A)withXmx(new Integer(arg1));
    }

    public A withNewXmx(int arg1) {
        return (A)withXmx(new Integer(arg1));
    }

    public Boolean getServer() {
        return this.server;
    }

    public A withServer(Boolean server) {
        this.server=server; return (A) this;
    }

    public Boolean hasServer() {
        return this.server != null;
    }

    public A withNewServer(String arg1) {
        return (A)withServer(new Boolean(arg1));
    }

    public A withNewServer(boolean arg1) {
        return (A)withServer(new Boolean(arg1));
    }

    public Boolean getUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public A withUseStringDeduplication(Boolean useStringDeduplication) {
        this.useStringDeduplication=useStringDeduplication; return (A) this;
    }

    public Boolean hasUseStringDeduplication() {
        return this.useStringDeduplication != null;
    }

    public A withNewUseStringDeduplication(String arg1) {
        return (A)withUseStringDeduplication(new Boolean(arg1));
    }

    public A withNewUseStringDeduplication(boolean arg1) {
        return (A)withUseStringDeduplication(new Boolean(arg1));
    }

    public Boolean getPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public A withPreferIPv4Stack(Boolean preferIPv4Stack) {
        this.preferIPv4Stack=preferIPv4Stack; return (A) this;
    }

    public Boolean hasPreferIPv4Stack() {
        return this.preferIPv4Stack != null;
    }

    public A withNewPreferIPv4Stack(String arg1) {
        return (A)withPreferIPv4Stack(new Boolean(arg1));
    }

    public A withNewPreferIPv4Stack(boolean arg1) {
        return (A)withPreferIPv4Stack(new Boolean(arg1));
    }

    public Boolean getHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public A withHeapDumpOnOutOfMemoryError(Boolean heapDumpOnOutOfMemoryError) {
        this.heapDumpOnOutOfMemoryError=heapDumpOnOutOfMemoryError; return (A) this;
    }

    public Boolean hasHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError != null;
    }

    public A withNewHeapDumpOnOutOfMemoryError(String arg1) {
        return (A)withHeapDumpOnOutOfMemoryError(new Boolean(arg1));
    }

    public A withNewHeapDumpOnOutOfMemoryError(boolean arg1) {
        return (A)withHeapDumpOnOutOfMemoryError(new Boolean(arg1));
    }

    public Boolean getUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public A withUseGCOverheadLimit(Boolean useGCOverheadLimit) {
        this.useGCOverheadLimit=useGCOverheadLimit; return (A) this;
    }

    public Boolean hasUseGCOverheadLimit() {
        return this.useGCOverheadLimit != null;
    }

    public A withNewUseGCOverheadLimit(String arg1) {
        return (A)withUseGCOverheadLimit(new Boolean(arg1));
    }

    public A withNewUseGCOverheadLimit(boolean arg1) {
        return (A)withUseGCOverheadLimit(new Boolean(arg1));
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public A withGc(GarbageCollector gc) {
        this.gc=gc; return (A) this;
    }

    public Boolean hasGc() {
        return this.gc != null;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public A withSecureRandom(SecureRandomSource secureRandom) {
        this.secureRandom=secureRandom; return (A) this;
    }

    public Boolean hasSecureRandom() {
        return this.secureRandom != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmConfigFluentImpl that = (JvmConfigFluentImpl) o;
        if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
        if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
        if (server != null ? !server.equals(that.server) :that.server != null) return false;
        if (useStringDeduplication != null ? !useStringDeduplication.equals(that.useStringDeduplication) :that.useStringDeduplication != null) return false;
        if (preferIPv4Stack != null ? !preferIPv4Stack.equals(that.preferIPv4Stack) :that.preferIPv4Stack != null) return false;
        if (heapDumpOnOutOfMemoryError != null ? !heapDumpOnOutOfMemoryError.equals(that.heapDumpOnOutOfMemoryError) :that.heapDumpOnOutOfMemoryError != null) return false;
        if (useGCOverheadLimit != null ? !useGCOverheadLimit.equals(that.useGCOverheadLimit) :that.useGCOverheadLimit != null) return false;
        if (gc != null ? !gc.equals(that.gc) :that.gc != null) return false;
        if (secureRandom != null ? !secureRandom.equals(that.secureRandom) :that.secureRandom != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
    }

}
