package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

public interface JvmConfigFluent<A extends JvmConfigFluent<A>> extends ConfigurationFluent<A> {


    public Integer getXms();
    public A withXms(Integer xms);
    public Boolean hasXms();
    public A withNewXms(String arg1);
    public A withNewXms(int arg1);
    public Integer getXmx();
    public A withXmx(Integer xmx);
    public Boolean hasXmx();
    public A withNewXmx(String arg1);
    public A withNewXmx(int arg1);
    public Boolean getServer();
    public A withServer(Boolean server);
    public Boolean hasServer();
    public A withNewServer(String arg1);
    public A withNewServer(boolean arg1);
    public Boolean getUseStringDeduplication();
    public A withUseStringDeduplication(Boolean useStringDeduplication);
    public Boolean hasUseStringDeduplication();
    public A withNewUseStringDeduplication(String arg1);
    public A withNewUseStringDeduplication(boolean arg1);
    public Boolean getPreferIPv4Stack();
    public A withPreferIPv4Stack(Boolean preferIPv4Stack);
    public Boolean hasPreferIPv4Stack();
    public A withNewPreferIPv4Stack(String arg1);
    public A withNewPreferIPv4Stack(boolean arg1);
    public Boolean getHeapDumpOnOutOfMemoryError();
    public A withHeapDumpOnOutOfMemoryError(Boolean heapDumpOnOutOfMemoryError);
    public Boolean hasHeapDumpOnOutOfMemoryError();
    public A withNewHeapDumpOnOutOfMemoryError(String arg1);
    public A withNewHeapDumpOnOutOfMemoryError(boolean arg1);
    public Boolean getUseGCOverheadLimit();
    public A withUseGCOverheadLimit(Boolean useGCOverheadLimit);
    public Boolean hasUseGCOverheadLimit();
    public A withNewUseGCOverheadLimit(String arg1);
    public A withNewUseGCOverheadLimit(boolean arg1);
    public GarbageCollector getGc();
    public A withGc(GarbageCollector gc);
    public Boolean hasGc();
    public SecureRandomSource getSecureRandom();
    public A withSecureRandom(SecureRandomSource secureRandom);
    public Boolean hasSecureRandom();
}
