package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class GeneratorConfig extends Configuration {

    private String inputPath;
    private String outputPath;

    public GeneratorConfig() {
    }

    public GeneratorConfig(Project project,Map<ConfigKey,Object> attributes,String inputPath,String outputPath) {
        super(project, attributes);
        this.inputPath = inputPath;
        this.outputPath = outputPath;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GeneratorConfig that = (GeneratorConfig) o;
        if (inputPath != null ? !inputPath.equals(that.inputPath) :that.inputPath != null) return false;
        if (outputPath != null ? !outputPath.equals(that.outputPath) :that.outputPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(inputPath,  outputPath,  super.hashCode());
    }

}
