package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.fabric8.kubernetes.api.builder.Editable;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

public class EditableJvmConfig extends JvmConfig implements Editable<JvmConfigBuilder> {


    public EditableJvmConfig() {
        super();
    }

    public EditableJvmConfig(Project project,Map<ConfigKey,Object> attributes,Integer xms,Integer xmx,Boolean server,Boolean useStringDeduplication,Boolean preferIPv4Stack,Boolean heapDumpOnOutOfMemoryError,Boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom) {
        super(project, attributes, xms, xmx, server, useStringDeduplication, preferIPv4Stack, heapDumpOnOutOfMemoryError, useGCOverheadLimit, gc, secureRandom);
    }

    public JvmConfigBuilder edit() {
        return new JvmConfigBuilder(this);
    }

}
