package io.dekorate.option.config;

import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.option.annotation.GarbageCollector;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class JvmConfig extends Configuration {

    private Integer xms;
    private Integer xmx;
    private Boolean server;
    private Boolean useStringDeduplication;
    private Boolean preferIPv4Stack;
    private Boolean heapDumpOnOutOfMemoryError;
    private Boolean useGCOverheadLimit;
    private GarbageCollector gc;
    private SecureRandomSource secureRandom;

    public JvmConfig() {
    }

    public JvmConfig(Project project,Map<ConfigKey,Object> attributes,Integer xms,Integer xmx,Boolean server,Boolean useStringDeduplication,Boolean preferIPv4Stack,Boolean heapDumpOnOutOfMemoryError,Boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom) {
        super(project, attributes);
        this.xms = xms;
        this.xmx = xmx;
        this.server = server;
        this.useStringDeduplication = useStringDeduplication;
        this.preferIPv4Stack = preferIPv4Stack;
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        this.useGCOverheadLimit = useGCOverheadLimit;
        this.gc = gc;
        this.secureRandom = secureRandom;
    }

    public Integer getXms() {
        return this.xms;
    }

    public Integer getXmx() {
        return this.xmx;
    }

    public Boolean getServer() {
        return this.server;
    }

    public boolean isServer() {
        return this.server != null &&  this.server;
    }

    public Boolean getUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public boolean isUseStringDeduplication() {
        return this.useStringDeduplication != null &&  this.useStringDeduplication;
    }

    public Boolean getPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public boolean isPreferIPv4Stack() {
        return this.preferIPv4Stack != null &&  this.preferIPv4Stack;
    }

    public Boolean getHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public boolean isHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError != null &&  this.heapDumpOnOutOfMemoryError;
    }

    public Boolean getUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public boolean isUseGCOverheadLimit() {
        return this.useGCOverheadLimit != null &&  this.useGCOverheadLimit;
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmConfig that = (JvmConfig) o;
        if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
        if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
        if (server != null ? !server.equals(that.server) :that.server != null) return false;
        if (useStringDeduplication != null ? !useStringDeduplication.equals(that.useStringDeduplication) :that.useStringDeduplication != null) return false;
        if (preferIPv4Stack != null ? !preferIPv4Stack.equals(that.preferIPv4Stack) :that.preferIPv4Stack != null) return false;
        if (heapDumpOnOutOfMemoryError != null ? !heapDumpOnOutOfMemoryError.equals(that.heapDumpOnOutOfMemoryError) :that.heapDumpOnOutOfMemoryError != null) return false;
        if (useGCOverheadLimit != null ? !useGCOverheadLimit.equals(that.useGCOverheadLimit) :that.useGCOverheadLimit != null) return false;
        if (gc != null ? !gc.equals(that.gc) :that.gc != null) return false;
        if (secureRandom != null ? !secureRandom.equals(that.secureRandom) :that.secureRandom != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
    }

}
